﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    /// <summary>
    /// ゲームパッドの情報を提供します。
    /// </summary>
    internal sealed class GamePadInfo
    {
        /// <summary>
        /// GamePadInfo クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="samplerId">ゲームパッドのサンプラーの識別子です。</param>
        /// <param name="name">ゲームパッドの名前です。</param>
        internal GamePadInfo(int samplerId, string name)
        {
            this.SamplerId = samplerId;

            this.Name = name;
        }

        /// <summary>
        /// ゲームパッドのサンプラーの識別子を取得します。
        /// </summary>
        internal int SamplerId { get; private set; }

        /// <summary>
        /// ゲームパッドの名前を取得します。
        /// </summary>
        internal string Name { get; private set; }
    }
}
