﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace HidShell.Devices
{
    using System.ComponentModel.Composition;

    /// <summary>
    /// JoyConL を扱うクラスです。
    /// </summary>
    [PartCreationPolicy(CreationPolicy.NonShared)]
    internal sealed class JoyConL : IDevice
    {
        private const string DeviceType = "JoyConL";

        private readonly AbstractedPad abstractedPad = new AbstractedPad();

        /// <summary>
        /// JoyConL クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal JoyConL()
        {
            this.abstractedPad.SetDeviceType(DeviceType);

            this.abstractedPad.SetJoyConLMode();
        }

        /// <summary>
        /// ポートを設定します。
        /// </summary>
        /// <param name="port">ポートです。</param>
        public void SetPort(uint port)
        {
            this.abstractedPad.SetPort(port);
        }

        /// <summary>
        /// ロガーを設定します。
        /// </summary>
        /// <param name="logger">ロガーです。</param>
        public void SetLogger(Logger logger)
        {
            this.abstractedPad.SetLogger(logger);
        }

        /// <summary>
        /// 指定されたデバイス種別をサポートするか否かを表す値を返します。
        /// </summary>
        /// <param name="deviceType">デバイス種別を表す文字列です。</param>
        /// <returns>指定されたデバイス種別をサポートするか否かを表す値です。</returns>
        public bool Supports(string deviceType)
        {
            return deviceType == DeviceType;
        }

        /// <summary>
        /// デバイス識別子で指定されたデバイスについてイベントをダンプします。
        /// </summary>
        /// <param name="deviceId">デバイス識別子です。</param>
        public void DumpEvent(string deviceId)
        {
            this.abstractedPad.DumpEvent(deviceId);
        }

        /// <summary>
        /// デバイス識別子で指定されたデバイスに対してイベントを発行します。
        /// </summary>
        /// <param name="deviceId">デバイス識別子です。</param>
        /// <param name="eventType">イベント種別です。</param>
        /// <param name="eventArgs">イベント引数です。</param>
        public void SendEvent(
            string deviceId, string eventType, string[] eventArgs)
        {
            this.abstractedPad.SendEvent(deviceId, eventType, eventArgs);
        }
    }
}
