﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>
#include <winsock.h>
#include <nw/ut/ut_SafeString.h>

#pragma comment(lib, "ws2_32.lib")	// WinSockのライブラリをリンク

namespace {

void format_option(nw::ut::BufferedSafeString* buf, int argc, char** argv)
{
    buf->clear();
    for (int i = 1; i < argc; i++)
    {
        if (i > 1)
        {
            buf->append(' ');
        }
        buf->append(argv[i]);
    }
}


bool send_lytviewer_command(u32 port, const nw::ut::BufferedSafeString& str)
{
    bool is_send = false;
    sockaddr_in saddr = { 0 };
    saddr.sin_family = AF_INET;
    saddr.sin_addr.S_un.S_addr = inet_addr("127.0.0.1");
    saddr.sin_port = htons(static_cast<u_short>(port));

    SOCKET soc = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

    int result = connect(soc, (sockaddr*)&saddr, sizeof (saddr));
    if (result >= 0) {
        send(soc, str.c_str(), str.calcLength() + 1, 0);
        is_send = true;
    } else {
        NW_LOG("connect to %d failed: %d", port, result);
    }

    closesocket(soc);

    return is_send;
}

} // namespace

int main(int argc, char** argv)
{
    if (argc <= 1) {
        NW_LOG("usage: lyt_hio_message.exe [messages]");
        return 2;
    }

    // 実行ファイルと同じフォルダにある"create_arc.bat"を実行する
    {
        const u32 cPathMax = 512;
        nw::ut::FixedSafeString<cPathMax> buf;
        GetModuleFileNameA(NULL, buf.getBuffer(), cPathMax);
        s32 index = buf.rfindIndex("\\");
        NW_ASSERT(index >= 0);
        buf.copyAt(index + 1, "create_arc.bat", 15);
        system(buf.c_str());
    }

    int return_code = 1;
    WSADATA wsaData = { 0 };

    {
        int result = WSAStartup(MAKEWORD(2,2), &wsaData);
        if (result < 0) {
            NW_LOG("WSAStartup failed: %d", result);
            return 1;
        }
    }

    // Create a socket to start listening to port 6003 on the localhost.
    SOCKET soc = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

    sockaddr_in saddr = { 0 };
    saddr.sin_family = AF_INET;
    saddr.sin_addr.S_un.S_addr = inet_addr("127.0.0.1");

    // Connect to the port.
    saddr.sin_port = htons(6003);
    int result = connect(soc, (sockaddr*)&saddr, sizeof (saddr));

    if (result >= 0) {
        int count = 0;

        // ノンブロッキングモードにする
        {
            u_long val = 1;
            ioctlsocket(soc, FIONBIO, &val);
        }

        for (; ; ) {
            char buf[256];
            int bytesRecv = recv(soc, buf, sizeof(buf) - 1, 0);

            if (bytesRecv > 0) {
                buf[bytesRecv] = '\0';
                nw::ut::BufferedSafeString str(buf, 256);
                s32 index = str.findIndex("+NW4FLytViewer:");
                if (index >= 0) {
                    // レイアウトビューアのチャンネルが見つかった
                    // 15文字先にチャンネルの数値がある
                    u32 port = static_cast<u32>(atoi(str.c_str() + 15));
                    NW_LOG("channel NW4FLytViewer found. port = %d", port);
                    // 見つかったチャンネルに接続し、コマンドを送る
                    nw::ut::FixedSafeString<512> option_buf;
                    format_option(&option_buf, argc, argv);
                    if (send_lytviewer_command(port, option_buf)) {
                        return_code = 0;
                    }
                    break;
                } else {
                    // レイアウトビューアのチャンネルが見つからない、レイアウトビューアが動作していない
                    NW_LOG("channel NW4FLytViewer not found");
                    break;
                }
            } else if (bytesRecv < 0) {
                if (WSAGetLastError() == WSAEWOULDBLOCK) {
                    if (count >= 100) {
                        // 一定回数試行してだめなら終了
                        NW_LOG("recv timeout");
                        break;
                    } else {
                        Sleep(10);
                        count++;
                    }
                } else {
                    NW_LOG("recv error: %d", bytesRecv);
                    break;
                }
            }
        }
    } else {
        NW_LOG("connect failed: %d", result);
    }

    // close the socket listing on port 6003.
    closesocket(soc);

    return return_code;
}
