﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace InputCapture.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class SettingsForm : Form
    {
        UserSettings _userSettings = null;
        bool _settingHotKey = false;
        Keys _hotKey = Keys.None;
        Keys _hotKeyModifier = Keys.None;

        public SettingsForm(UserSettings userSettings)
        {
            InitializeComponent();

            _userSettings = userSettings;
        }

        private void SettingsForm_Load(object sender, System.EventArgs e)
        {
            this.ApplayUserSetting(_userSettings);

            this.UpdateEnabledFlag();
        }

        private void SettingsForm_Closed(object sender, System.EventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                {
                    _userSettings.IsCaptureOnMousePosition = checkBox1.Checked;

                    _userSettings.CaptureBorderType = BorderType.Right;
                    if (radioButton2.Checked)
                    {
                        _userSettings.CaptureBorderType = BorderType.Left;
                    }
                    else if (radioButton3.Checked)
                    {
                        _userSettings.CaptureBorderType = BorderType.Top;
                    }
                    else if (radioButton4.Checked)
                    {
                        _userSettings.CaptureBorderType = BorderType.Bottom;
                    }

                    _userSettings.CaptureBorderSwitchType = BorderSwitchType.None;
                    if (radioButton6.Checked)
                    {
                        _userSettings.CaptureBorderSwitchType = BorderSwitchType.LClick;
                    }
                    else if (radioButton7.Checked)
                    {
                        _userSettings.CaptureBorderSwitchType = BorderSwitchType.LDoubleClick;
                    }

                    _userSettings.IsCaptureOnHotKey = checkBox2.Checked;

                    _userSettings.HotKey = _hotKey;
                    _userSettings.HotKeyModifier = _hotKeyModifier;
                }

                {
                    _userSettings.IsAutoConnect = checkBox3.Checked;
                    _userSettings.IsAutoDisconnect = checkBox4.Checked;
                    _userSettings.CheckAliveInterval = Decimal.ToUInt32(numericUpDown2.Value);
                    _userSettings.PollingInterval = Decimal.ToUInt32(numericUpDown1.Value);
                }

                _userSettings.SaveAppSettings();
            }
        }

        private void ApplayUserSetting(UserSettings userSettings)
        {
            this.ApplayUserSetting_Switching(userSettings);
            this.ApplayUserSetting_Connection(userSettings);
        }

        private void ApplayUserSetting_Switching(UserSettings userSettings)
        {
            checkBox1.Checked = userSettings.IsCaptureOnMousePosition;
            {
                radioButton1.Checked = true;
                if (userSettings.CaptureBorderType == BorderType.Left)
                {
                    radioButton2.Checked = true;
                }
                else if (userSettings.CaptureBorderType == BorderType.Top)
                {
                    radioButton3.Checked = true;
                }
                else if (userSettings.CaptureBorderType == BorderType.Bottom)
                {
                    radioButton4.Checked = true;
                }

                radioButton5.Checked = true;
                if (userSettings.CaptureBorderSwitchType == BorderSwitchType.LClick)
                {
                    radioButton6.Checked = true;
                }
                else if (userSettings.CaptureBorderSwitchType == BorderSwitchType.LDoubleClick)
                {
                    radioButton7.Checked = true;
                }

                this.UpdateCapturePosition();
            }

            checkBox2.Checked = userSettings.IsCaptureOnHotKey;
            {
                ShowHotKey(userSettings.HotKey, userSettings.HotKeyModifier);
            }
        }

        private void ApplayUserSetting_Connection(UserSettings userSettings)
        {
            checkBox3.Checked = userSettings.IsAutoConnect;
            checkBox4.Checked = userSettings.IsAutoDisconnect;
            numericUpDown2.Value = userSettings.CheckAliveInterval;

            numericUpDown1.Value = userSettings.PollingInterval;
        }

        /// <summary>
        /// チェックボックスの状態から各コントロールの Enabled 設定を更新します。
        /// </summary>
        private void UpdateEnabledFlag()
        {
            radioButton1.Enabled = checkBox1.Checked;
            radioButton2.Enabled = checkBox1.Checked;
            radioButton3.Enabled = checkBox1.Checked;
            radioButton4.Enabled = checkBox1.Checked;
            groupBox4.Enabled = checkBox1.Checked;

            label3.Enabled = checkBox2.Checked;
            label4.Enabled = checkBox2.Checked;
            textBox1.Enabled = checkBox2.Checked;
            label5.Enabled = checkBox2.Checked;

            numericUpDown2.Enabled = checkBox4.Checked;
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            UpdateEnabledFlag();
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            UpdateEnabledFlag();
        }

        private void checkBox4_CheckedChanged(object sender, EventArgs e)
        {
            UpdateEnabledFlag();
        }

        private void label5_Click(object sender, EventArgs e)
        {
            _settingHotKey = true;
        }

        private void SettingsForm_KeyUp(object sender, KeyEventArgs e)
        {
            if (_settingHotKey)
            {
                if (e.KeyCode != Keys.ShiftKey &&
                    e.KeyCode != Keys.ControlKey &&
                    e.KeyCode != Keys.Menu &&
                    !(e.KeyCode == Keys.F12 && e.Modifiers == Keys.None))
                {
                    System.Diagnostics.Debug.WriteLine("e.KeyCode " + (int)e.KeyCode);
                    _hotKey = e.KeyCode;
                    _hotKeyModifier = e.Modifiers;

                    ShowHotKey(_hotKey, _hotKeyModifier);
                }

                _settingHotKey = false;
            }
        }

        private void ShowHotKey(Keys hotKey, Keys hotKeyModifier)
        {
            _hotKey = hotKey;
            _hotKeyModifier = hotKeyModifier;

            string setModifier = "";
            if (hotKeyModifier != Keys.None)
            {
                setModifier = hotKeyModifier.ToString() + " + ";
            }

            textBox1.Text = setModifier + hotKey.ToString();
        }

        private void groupBox1_Enter(object sender, EventArgs e)
        {
            _settingHotKey = false;
        }

        private void groupBox2_Enter(object sender, EventArgs e)
        {
            _settingHotKey = false;
        }

        private void tabControl1_Click(object sender, EventArgs e)
        {
            _settingHotKey = false;
        }

        private void radioButtonPosition_CheckedChanged(object sender, EventArgs e)
        {
            this.UpdateCapturePosition();
        }

        private void UpdateCapturePosition()
        {
            if (this.radioButton1.Checked)
            {
                this.pictureBoxPC.Location = new Point(26, 40);
                this.pictureBoxTV.Location = new Point(102, 40);
            }
            else if (this.radioButton2.Checked)
            {
                this.pictureBoxPC.Location = new Point(102, 40);
                this.pictureBoxTV.Location = new Point(26, 40);
            }
            else if (this.radioButton3.Checked)
            {
                this.pictureBoxPC.Location = new Point(64, 69);
                this.pictureBoxTV.Location = new Point(64, 12);
            }
            else if (this.radioButton4.Checked)
            {
                this.pictureBoxPC.Location = new Point(64, 12);
                this.pictureBoxTV.Location = new Point(64, 69);
            }
        }
    }
}
