﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace InputCapture.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class AboutDialog : Form
    {
        public AboutDialog()
        {
            InitializeComponent();

            Icon icon = new Icon(this.Icon, 48, 48);
            this.pictureBoxIcon.Image = icon.ToBitmap();

            labelProductName.Text = string.Format("{0} {1}",
                Application.ProductName,
                Application.ProductVersion);

            System.Reflection.AssemblyCopyrightAttribute assemblyCopyright = (System.Reflection.AssemblyCopyrightAttribute)
                Attribute.GetCustomAttribute(System.Reflection.Assembly.GetExecutingAssembly(), typeof(System.Reflection.AssemblyCopyrightAttribute));
            labelAssemblyCopyright.Text = assemblyCopyright.Copyright;
        }
    }
}
