﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// include
//=============================================================================
#include "ImageConvert.h"
#include "BinaryTypes.h"

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//-----------------------------------------------------------------------------
//! @brief bntx ファイルのデータを出力します。
//!
//! @param[in,out] os 出力ストリームです。
//! @param[in,out] pImages 画像へのポインタ配列です。
//! @param[in] binName バイナリファイル名です。
//! @param[in] binTileMode bntx ファイルのタイルモードです。
//! @param[in] enablesMemoryPool メモリプールを有効にするなら true です。
//! @param[in] convUtil 変換ユーティリティです。
//!
//! @return 処理結果を返します。
//-----------------------------------------------------------------------------
RStatus OutputBntxData(
    std::ostream& os,
    const std::vector<RImage*>& pImages,
    const std::string& binName,
    const std::string& binTileMode,
    const bool enablesMemoryPool,
    const ConverterUtility& convUtil
);

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

