﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//=============================================================================
// 関数型の定義です。
//=============================================================================

//! @brief 引数がグローバルオプションなら true を返します。
//!
//! @param[in] arg 引数です。
//!
//! @return 引数がグローバルオプションなら true を返します。
//!
typedef bool (*IsGlobalOptionArgFunc)(const wchar_t* arg);

//! @brief 指定した引数の次の引数がグローバルオプションの値なら true を返します。
//!
//! @param[in] arg 引数です。
//!
//! @return 次の引数がグローバルオプションの値なら true を返します。
//!
typedef bool (*IsNextArgGlobalOptionValueFunc)(const wchar_t* arg);

//! @brief 指定した引数の次の引数がジョブオプションの値なら true を返します。
//!
//! @param[in] arg 引数です。
//!
//! @return 次の引数がジョブオプションの値なら true を返します。
//!
typedef bool (*IsNextArgJobOptionValueFunc)(const wchar_t* arg);

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

