﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <locale>

#include <optflags.h>

#include <gfxTool_CompileOption-gx.h>
#include <gfxTool_CommandLineArg.h>

namespace {

uint64_t ParseOptimizeFlags( uint64_t flags, const nn::gfxTool::Custom< std::string >::Type& optimize )
{
    typedef nn::gfxTool::Custom< std::string >::Type StringType;

    static const struct OptFlag
    {
        const char* name;
        uint64_t bits;
    } optflags[] =
    {
        { "sc", 0x01ll << GSH2_OPTFLAG_SC },
        { "fastmath", 0x01ll << GSH2_OPTFLAG_FASTMATH },
        { "loopvar", 0x01ll << GSH2_OPTFLAG_LOOPVAR },
        { "const", 0x01ll << GSH2_OPTFLAG_CONST },
        { "loopexpr", 0x01ll << GSH2_OPTFLAG_LOOPEXPR },
        { "unusedvar", 0x01ll << GSH2_OPTFLAG_UNUSEDVAR },
        { "limitarraysyms", 0x01ll << GSH2_OPTFLAG_LIMITARRAYSYMS },
        { "glsl", 0x01ll << GSH2_OPTFLAG_GLSL },
        { "1", static_cast< uint64_t >( -1 ) },
        { "all", static_cast< uint64_t >( -1 ) },
        { "0", 0 },
        { "none", 0 },
        { nullptr, 0 }
    };

    std::locale locale( "C" );
    for( StringType::size_type pos = 0; pos != StringType::npos; pos = optimize.find_first_of( ',', pos ) )
    {
        if( pos != 0 )
        {
            ++pos;
        }
        while( std::isblank( optimize[ pos ], locale ) )
        {
            ++pos;
        }

        bool invert = false;
        if( optimize[ pos ] == '!' )
        {
            invert = true;
            ++pos;
        }
        else if( optimize.compare( pos, 3, "no-" ) == 0 )
        {
            invert = true;
            pos += 3;
        }
        for( int idxOption = 0; optflags[ idxOption ].name; ++idxOption )
        {
            auto length = strlen( optflags[ idxOption ].name );
            if( optimize.compare( pos, length, optflags[ idxOption ].name ) == 0
                && ( optimize[ pos + length ] == ',' || optimize[ pos + length ] == '\0' ||
                std::isblank( optimize[ pos + length ], locale ) ) )
            {
                if( optflags[ idxOption ].bits == 0 )
                {
                    flags = 0;
                }
                else if( invert )
                {
                    flags &= ~optflags[ idxOption ].bits;
                }
                else
                {
                    flags |= optflags[ idxOption ].bits;
                }
                break;
            }
        }
    }

    return flags;
}

}

namespace nn {
namespace gfxTool {

void CompileOptionGx::Initialize( const CommandLineArg* pInput )
{
    this->optimizeFlags = 0x01ll << GSH2_OPTFLAG_LIMITARRAYSYMS;

    if( pInput->gx2OptimizeFlags.IsExisting() )
    {
        this->optimizeFlags = ParseOptimizeFlags( this->optimizeFlags,
            pInput->gx2OptimizeFlags.GetValue() );
    }
    if( pInput->debugInfoDirectory.IsExisting() )
    {
        m_SparkDir = pInput->debugInfoDirectory.GetValue();
        this->pSparkOutputDir = m_SparkDir.c_str();
    }
}

}
}
