﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfxTool/gfxTool_DllBase.h>

#include <nn/gfxTool/gfxTool_ShaderCompilerApi.h>

namespace nn {
namespace gfxTool {

class ShaderCompilerDll
    : public DllBase
{
public:
    ShaderCompilerDll()
        : DllBase()
    {
    }

    virtual bool Initialize( const char* pDllPath ) override;

public:
    decltype( &::nngfxToolShaderCompilerCreateHandle ) CreateHandle;
    decltype( &::nngfxToolShaderCompilerResetHandle ) ResetHandle;
    decltype( &::nngfxToolShaderCompilerCompile ) Compile;
    decltype( &::nngfxToolShaderCompilerDeleteHandle ) DeleteHandle;
    decltype( &::nngfxToolShaderCompilerDeleteCompileOutput ) DeleteCompileOutput;
    decltype( &::nngfxToolShaderCompilerSetLogStream ) SetLogStream;
    decltype( &::nngfxToolShaderCompilerGetApiVersion ) GetApiVersion;
};

}
}
