﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class ShaderBinarizerContext;
class ResShaderContainerBinarizer;
class ResShaderProgramBinarizer;

class ResShaderVariationBinarizer
    : public BinarizerBase
{
public:
    typedef nn::gfx::ResShaderVariationData ResTarget;
    typedef nngfxToolShaderCompilerVariationOutput BinarizationTarget;

    ResShaderVariationBinarizer();

    ~ResShaderVariationBinarizer();

    void Initialize( const BinarizationTarget* pTarget,
        const ResShaderContainerBinarizer* pParent, int idxVariation );

    virtual void CalculateSize() override;
    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    const ResShaderContainerBinarizer* GetParent() const
    {
        return m_pParent;
    }

    const ResShaderProgramBinarizer* GetSourceProgramBinarizer() const
    {
        return m_pSourceProgram.get();
    }

    ResShaderProgramBinarizer* GetSourceProgramBinarizer()
    {
        return m_pSourceProgram.get();
    }

    const ResShaderProgramBinarizer* GetIntermediateLanguageProgramBinarizer() const
    {
        return m_pIntermediateLanguageProgram.get();
    }

    ResShaderProgramBinarizer* GetIntermediateLanguageProgramBinarizer()
    {
        return m_pIntermediateLanguageProgram.get();
    }

    const ResShaderProgramBinarizer* GetBinaryProgramBinarizer() const
    {
        return m_pBinaryProgram.get();
    }

    ResShaderProgramBinarizer* GetBinaryProgramBinarizer()
    {
        return m_pBinaryProgram.get();
    }

    int GetVariationIndex() const
    {
        return m_IdxVariation;
    }

private:
    template< typename TFunc >
    void ForEachProgram( TFunc func );

    const BinarizationTarget* m_pTarget;
    const ResShaderContainerBinarizer* m_pParent;

    std::shared_ptr< ResShaderProgramBinarizer > m_pSourceProgram;
    std::shared_ptr< ResShaderProgramBinarizer > m_pIntermediateLanguageProgram;
    std::shared_ptr< ResShaderProgramBinarizer > m_pBinaryProgram;

    int m_IdxVariation;
};

}
}
