﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// NOLINT(build/header_guard)

#if !defined( NN_GFXTOOL_ENUMSTRING_H_ )
#define NN_GFXTOOL_ENUMSTRING_H_

#include <nn/gfxTool/gfxTool_EnumHelper.h>

namespace nn {
namespace gfxTool {

// nngfxToolShaderCompilerPlatform と同じ順序
NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( Platform )
    NN_GFXTOOL_DEFINE_ENUM( Win )
    NN_GFXTOOL_DEFINE_ENUM( Cafe )
    NN_GFXTOOL_DEFINE_ENUM( Nx )
NN_GFXTOOL_DEFINE_ENUM_CLASS_END( Platform )

// nngfxToolShaderCompilerShaderSourceFormat と同じ順序
NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( SourceFormat )
    NN_GFXTOOL_DEFINE_ENUM( Glsl )
    NN_GFXTOOL_DEFINE_ENUM( SpirV )
    NN_GFXTOOL_DEFINE_ENUM( Hlsl )
NN_GFXTOOL_DEFINE_ENUM_CLASS_END( SourceFormat )

// nngfxToolShaderCompilerCodeType と同じ順序
NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( CodeType )
    NN_GFXTOOL_DEFINE_ENUM( Undefined )
    NN_GFXTOOL_DEFINE_ENUM( Binary )
    NN_GFXTOOL_DEFINE_ENUM( Source )
    NN_GFXTOOL_DEFINE_ENUM( Binary_Source )
    NN_GFXTOOL_DEFINE_ENUM( Binary_Ir )
    NN_GFXTOOL_DEFINE_ENUM( Ir )
    NN_GFXTOOL_DEFINE_ENUM( Ir_Source )
NN_GFXTOOL_DEFINE_ENUM_CLASS_END( CodeType )

// nngfxToolShaderCompilerLowLevelApiType と同じ順序
NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( ApiType )
    NN_GFXTOOL_DEFINE_ENUM( Gl )
    NN_GFXTOOL_DEFINE_ENUM( Gx )
    NN_GFXTOOL_DEFINE_ENUM( Nvn )
    NN_GFXTOOL_DEFINE_ENUM( D3d )
    NN_GFXTOOL_DEFINE_ENUM( Vk )
NN_GFXTOOL_DEFINE_ENUM_END( ApiType )

// nngfxToolShaderCompilerDebugInfoLevel と同じ順序
NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( DebugInfoLevel )
    NN_GFXTOOL_DEFINE_ENUM( None )
    NN_GFXTOOL_DEFINE_ENUM( Debug )
    NN_GFXTOOL_DEFINE_ENUM( High )
    NN_GFXTOOL_DEFINE_ENUM( Full )
NN_GFXTOOL_DEFINE_ENUM_END( DebugInfoLevel )

}
}

#endif
