﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfxTool/gfxTool_CommandLineParser.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

struct CommandLineArg
{
    CommandLineOption<> help;
    CommandLineOption<> version;
    CommandLineOption< Custom< std::string >::Type > shaderFile[ static_cast< int >( ShaderStage::End ) ];
    CommandLineOption< Custom< std::string >::Type > variationFile;
    CommandLineOption< Custom< std::string >::Type > outputPath;
    CommandLineOption< Custom< std::string >::Type > dumpDirectory;
    CommandLineOption<> printProgress;
    CommandLineOption<> silent;
    CommandLineOption< Custom< std::string >::Type[] > includeDirectory;
    CommandLineOption< SourceFormat > sourceFormat;
    CommandLineOption< CodeType > codeType;
    CommandLineOption< ApiType > apiType;
    CommandLineOption< Custom< std::string >::Type > glslVersion;
    CommandLineOption< Custom< std::string >::Type[] > glslExtensions;
    CommandLineOption< Custom< std::string >::Type[] > preprocessorDefinitions;
    CommandLineOption< Custom< std::string >::Type > outputName;
    CommandLineOption< int > maxThread;
    CommandLineOption< int > jobs;
    CommandLineOption< int > codePage;
    CommandLineOption<> separable;
    CommandLineOption<> reflection;
    CommandLineOption<> reflectionFull;
    CommandLineOption<> disableMemoryPool;
    CommandLineOption<> preprocess;
    CommandLineOption< DebugInfoLevel > debugInfoLevel;
    CommandLineOption< Custom< std::string >::Type > debugInfoDirectory;
    CommandLineOption< Custom< std::string >::Type > shaderCacheDirectory;
    CommandLineOption< Custom< std::string >::Type > uniformRegisterBlockName;
    CommandLineOption<> disableMergeProgram;

    CommandLineOption< Custom< std::string >::Type > gx2OptimizeFlags;

    CommandLineOption<> decomposeBinary;
    CommandLineOption< Custom< std::string >::Type > glslcOptionFlags;

    CommandLineOption<> autoMapUniformBinding;
    CommandLineOption<> autoMapInOutLocation;

    CommandLineOption< Custom< std::string >::Type[] > mergeShaderFile;

    CommandLineOption<> invertGlPositionY;
    CommandLineOption<> remapGlPositionZ;
};

void InitializeOptions( CommandLineArg* pOptions, CommandLineParser* pParser );

}
}
