﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/util/util_MemorySplitter.h>

namespace nn {
namespace gfxTool {

class ShaderBinarizerContext;

class BinarizerBase
    : public nn::util::MemorySplitter::MemoryBlock
{
public:
    virtual ~BinarizerBase()
    {
    }

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) = 0;
    virtual void CalculateSize() = 0;
    virtual void Link( ShaderBinarizerContext* pContext ) = 0;
    virtual void Convert( ShaderBinarizerContext* pContext ) = 0;
};

}
}
