﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <fstream>

#include <nn/gfxTool/gfxTool_ShaderCompilerApi-gx.h>
#include <nn/gfxTool/gfxTool_ShaderUtils.h>

#include <gfxTool_Dump.h>

namespace nn {
namespace gfxTool {

template<>
void DumpStatistics< static_cast< nngfxToolShaderCompilerLowLevelApiType >(
    nngfxToolShaderCompilerLowLevelApiType_Gx ) >( std::ostream* pOs, const void* pStatistics )
{
    if( pOs == nullptr || pStatistics == nullptr )
    {
        return;
    }

    auto& os = *pOs;
    auto& statistics = *static_cast< const GSH2ShaderStats* >( pStatistics );
    os << "NumInst: " << statistics.uNumInst;
    os << "\nNumTempReg: " << statistics.uNumTempReg;
    os << "\nNumClauseTempReg: " << statistics.uNumClauseTempReg;
    os << "\nGPRPoolSize: " << statistics.uGPRPoolSize;
    os << "\nNumALUInst: " << statistics.uNumALUInst;
    os << "\nNumTfetchInst: " << statistics.uNumTfetchInst;
    os << "\nNumVfetchInst: " << statistics.uNumVfetchInst;
    os << "\nNumCflowInst: " << statistics.uNumCflowInst;
    os << "\nNumALUConstReg: " << statistics.uNumALUConstReg;
    os << "\n\n\n";
}

}
}
