﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_VariationOutput.h>
#include <gfxTool_ProgramOutput.h>

namespace nn {
namespace gfxTool {

VariationOutput::VariationOutput()
{
}

VariationOutput::~VariationOutput() /* = default; */
{
}

void VariationOutput::Initialize( const nngfxToolShaderCompilerCompileArg* pArg,
    nngfxToolShaderCompilerVariationOutput* pOutput )
{
    this->m_pOutput = pOutput;

    this->m_pOutput->pSourceOutput = nullptr;
    auto codeType = static_cast< nngfxToolShaderCompilerCodeType >( pArg->targetCodeType );
    if( HasSource( codeType ) )
    {
        m_pSourceOutput.reset( new ProgramOutput() );
        m_pSourceOutput.get()->Initialize( pArg );
        this->m_pOutput->pSourceOutput = m_pSourceOutput.get()->GetOutput();
    }

    this->m_pOutput->pIntermediateLanguageOutput = nullptr;
    if( HasIr( codeType ) && !( codeType == nngfxToolShaderCompilerCodeType_Binary_Ir &&
        pArg->targetLowLevelApiType == nngfxToolShaderCompilerLowLevelApiType_Nvn ) )
    {
        m_pIrOutput.reset( new ProgramOutput() );
        m_pIrOutput.get()->Initialize( pArg );
        this->m_pOutput->pIntermediateLanguageOutput = m_pIrOutput.get()->GetOutput();
    }

    this->m_pOutput->pBinaryOutput = nullptr;
    if( HasBinary( codeType ) )
    {
        m_pBinaryOutput.reset( new ProgramOutput() );
        m_pBinaryOutput.get()->Initialize( pArg );
        this->m_pOutput->pBinaryOutput = m_pBinaryOutput.get()->GetOutput();
    }
}

}
}
