﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_CompileOutput.h>
#include <gfxTool_VariationOutput.h>

namespace nn {
namespace gfxTool {

CompileOutput::CompileOutput()
    : nngfxToolShaderCompilerCompileOutput()
{
}

CompileOutput::~CompileOutput()
{
}

void CompileOutput::Initialize( const nngfxToolShaderCompilerCompileArg* pArg )
{
    m_pVariationOutputArrayRaw.reset( new nngfxToolShaderCompilerVariationOutput[ pArg->variationCount ] );
    m_pVariationOutputArray.reset( new VariationOutput[ pArg->variationCount ] );
    this->pVariationOutputArray = m_pVariationOutputArrayRaw.get();
    for( int idxVariation = 0, variationCountMax = NumericCastAuto( pArg->variationCount );
        idxVariation < variationCountMax; ++idxVariation )
    {
        m_pVariationOutputArray[ idxVariation ].Initialize(
            pArg, m_pVariationOutputArrayRaw.get() + idxVariation );
    }

    auto codeType = static_cast< nngfxToolShaderCompilerCodeType >( pArg->targetCodeType );
    if( HasSource( codeType ) )
    {
        m_pSourceOutput.reset( new SourceOutput() );
    }
}

}
}
