﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <list>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class OptionOutputReflection
    : private nngfxToolShaderCompilerShaderReflection
{
public:
    OptionOutputReflection()
        : nngfxToolShaderCompilerShaderReflection()
    {
    }

    nngfxToolShaderCompilerShaderReflection* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerShaderReflection* >( this );
    }

    void AddReflection( const nngfxToolShaderCompilerConstantBuffer& constantBuffer )
    {
        AddReflection( &m_ConstantBufferArray, &this->constantBufferCount,
            &this->pConstantBufferArray, constantBuffer );
    }

    void AddReflection( const nngfxToolShaderCompilerUnorderedAccessBuffer& unorderedAccessBuffer )
    {
        AddReflection( &m_UnorderedAccessBufferArray, &this->unorderedAccessBufferCount,
            &this->pUnorderedAccessBufferArray, unorderedAccessBuffer );
    }

    void AddReflection( const nngfxToolShaderCompilerShaderInput& shaderInput )
    {
        AddReflection( &m_ShaderInputArray, &this->shaderInputCount,
            &this->pShaderInputArray, shaderInput );
    }

    void AddReflection( const nngfxToolShaderCompilerShaderOutput& shaderOutput )
    {
        AddReflection( &m_ShaderOutputArray, &this->shaderOutputCount,
            &this->pShaderOutputArray, shaderOutput );
    }

    void AddReflection( const nngfxToolShaderCompilerSampler& sampler )
    {
        AddReflection( &m_SamplerArray, &this->samplerCount, &this->pSamplerArray, sampler );
    }

    void AddReflection( const nngfxToolShaderCompilerImage& image )
    {
        AddReflection( &m_ImageArray, &this->imageCount, &this->pImageArray, image );
    }

    void AddReflection( const nngfxToolShaderCompilerSeparateTexture& separateTexture )
    {
        AddReflection( &m_SeparateTextureArray, &this->separateTextureCount,
            &this->pSeparateTextureArray, separateTexture );
    }

    void AddReflection( const nngfxToolShaderCompilerSeparateSampler& separateSampler )
    {
        AddReflection( &m_SeparateSamplerArray, &this->separateSamplerCount,
            &this->pSeparateSamplerArray, separateSampler );
    }

    void AddReflection( const nngfxToolShaderCompilerConstantBufferVariable& constantBufferVariable )
    {
        AddReflection( &m_ConstantBufferVariableArray, &this->constantBufferVariableCount,
            &this->pConstantBufferVariableArray, constantBufferVariable );
    }

    void AddReflection( const nngfxToolShaderCompilerUnorderedAccessBufferVariable& unorderedAccessBufferVariable )
    {
        AddReflection( &m_UnorderedAccessBufferVariableArray, &this->unorderedAccessBufferVariableCount,
            &this->pUnorderedAccessBufferVariableArray, unorderedAccessBufferVariable );
    }

private:
    template< typename ReflectionType >
    void AddReflection( typename Custom< std::vector< ReflectionType > >::Type* pReflectionArray,
        uint32_t* pCount, ReflectionType** pReflectionPtr, const ReflectionType& reflection )
    {
        pReflectionArray->push_back( reflection );
        m_Strings.push_back( Custom< std::string >::Type( reflection.name.pValue, reflection.name.length ) );
        pReflectionArray->back().name.pValue = m_Strings.back().c_str();
        pReflectionArray->back().name.length = NumericCastAuto( m_Strings.back().length() );
        *pCount = NumericCastAuto( pReflectionArray->size() );
        *pReflectionPtr = &(*pReflectionArray)[ 0 ];
    }

    Custom< std::vector< nngfxToolShaderCompilerConstantBuffer > >::Type m_ConstantBufferArray;
    Custom< std::vector< nngfxToolShaderCompilerUnorderedAccessBuffer
        > >::Type m_UnorderedAccessBufferArray;
    Custom< std::vector< nngfxToolShaderCompilerShaderInput > >::Type m_ShaderInputArray;
    Custom< std::vector< nngfxToolShaderCompilerShaderOutput > >::Type m_ShaderOutputArray;
    Custom< std::vector< nngfxToolShaderCompilerSampler > >::Type m_SamplerArray;
    Custom< std::vector< nngfxToolShaderCompilerConstantBufferVariable
        > >::Type m_ConstantBufferVariableArray;
    Custom< std::vector< nngfxToolShaderCompilerUnorderedAccessBufferVariable
        > >::Type m_UnorderedAccessBufferVariableArray;
    Custom< std::vector< nngfxToolShaderCompilerImage > >::Type m_ImageArray;
    Custom< std::vector< nngfxToolShaderCompilerSeparateTexture > >::Type m_SeparateTextureArray;
    Custom< std::vector< nngfxToolShaderCompilerSeparateSampler > >::Type m_SeparateSamplerArray;

    Custom< std::list< Custom< std::string >::Type > >::Type m_Strings;
};

class OptionOutputStageCommon
    : private nngfxToolShaderCompilerOptionOutputStageCommon
{
public:
    OptionOutputStageCommon()
        : nngfxToolShaderCompilerOptionOutputStageCommon()
    {
    }

    nngfxToolShaderCompilerOptionOutputStageCommon* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerOptionOutputStageCommon* >( this );
    }

    void SetInfoLog( std::shared_ptr< Custom< std::string >::Type > pInfoLog );
    void SetDump( std::shared_ptr< Custom< std::string >::Type > pDump );
    void SetShaderStatistics( std::shared_ptr< void > pShaderStatistics );

private:
    std::shared_ptr< Custom< std::string >::Type > m_pInfoLog;
    std::shared_ptr< Custom< std::string >::Type > m_pDump;
    std::shared_ptr< void > m_pShaderStatistics;
};

class OptionOutputProgramCommon
    : private nngfxToolShaderCompilerOptionOutputProgramCommon
{
public:
    OptionOutputProgramCommon()
        : nngfxToolShaderCompilerOptionOutputProgramCommon()
    {
    }

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg );

    nngfxToolShaderCompilerOptionOutputProgramCommon* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerOptionOutputProgramCommon* >( this );
    }

    OptionOutputStageCommon* GetOptionOutputStageCommon( ShaderStage stage )
    {
        return m_StageOutput + static_cast< int >( stage );
    }

    void SetReflection( std::shared_ptr< OptionOutputReflection > pValue )
    {
        m_pReflection = pValue;
        this->pReflection = m_pReflection->GetOutput();
    }

private:
    OptionOutputStageCommon m_StageOutput[ static_cast< int >( ShaderStage::End ) ];

    std::shared_ptr< OptionOutputReflection > m_pReflection;
};

}
}
