﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <algorithm>
#include <nn/nn_Macro.h>

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class GlobalWindow final
{
    NN_DISALLOW_COPY( GlobalWindow );

public:
    ~GlobalWindow();

    bool IsInitialized() const
    {
        return m_hWnd != nullptr;
    }

    void Initialize();

    HWND GetHandle()
    {
        return m_hWnd;
    }

    HDC GetDc()
    {
        return m_hDc;
    }

    static GlobalWindow& GetInstance()
    {
        static GlobalWindow instance;
        return std::ref( instance );
    }

private:
    GlobalWindow()
        : m_hWnd()
        , m_hDc()
    {
    }

    HWND m_hWnd;
    HDC m_hDc;
};

}
}
