﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <GL/glew.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

// ピクセルフォーマットが同じなら関数アドレスは共通
class GlFunction
{
public:
    GlFunction()
        : m_IsInitialized( false )
    {
    }

    ~GlFunction()
    {
        m_IsInitialized = false;
    }

    bool IsInitialized() const
    {
        return m_IsInitialized;
    }

    void Initialize();

    // 作成・破棄
    decltype( ::glCreateShader ) CreateShader;
    decltype( ::glDeleteShader ) DeleteShader;
    decltype( ::glCreateProgram ) CreateProgram;
    decltype( ::glDeleteProgram ) DeleteProgram;
    decltype( ::glReleaseShaderCompiler ) ReleaseShaderCompiler;

    // 問い合わせ
    decltype( ::glGetShaderiv ) GetShaderiv;
    decltype( ::glGetShaderInfoLog ) GetShaderInfoLog;
    decltype( ::glGetProgramiv ) GetProgramiv;
    decltype( ::glGetProgramInfoLog ) GetProgramInfoLog;

    // コンパイル
    decltype( ::glShaderSource ) ShaderSource;
    decltype( ::glCompileShader ) CompileShader;
    decltype( ::glAttachShader ) AttachShader;
    decltype( ::glDetachShader ) DetachShader;
    decltype( ::glLinkProgram ) LinkProgram;
    decltype( ::glProgramParameteri ) ProgramParameteri;

    // バイナリ取得
    decltype( ::glGetProgramBinary ) GetProgramBinary;

    // リフレクション
    decltype( ::glGetProgramInterfaceiv ) GetProgramInterfaceiv;
    decltype( ::glGetProgramResourceiv ) GetProgramResourceiv;
    decltype( ::glGetProgramResourceName ) GetProgramResourceName;
    decltype( ::glGetUniformiv ) GetUniformiv;

private:
    bool m_IsInitialized;
};

}
}
