﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <string>

#include <gfxTool_Common.h>
#include <gfxTool_CompileOption.h>

namespace nn {
namespace gfxTool {

template<>
class CompileOption< nngfxToolShaderCompilerOptionType_Glsl >
    : public CompileOptionBase
{
public:
    virtual void Initialize( const void* pOption ) override;

    const std::shared_ptr< Custom< std::string >::Type >& GetGlslHeader() const
    {
        return m_pGlslHeader;
    }

private:
    std::shared_ptr< Custom< std::string >::Type > m_pGlslHeader;
};

}
}
