﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_MCS_HIORINGBUFFER_H_
#define NW4R_MCS_HIORINGBUFFER_H_

#if _MSC_VER > 1000 || defined(__CWCC__)
#pragma once
#endif

#if defined(WIN32) || defined(NW4R_GC)

#include <nw/types.h>

//================================================================================
// コンパイルオプションのようなものの定義
// #define ENABLE_MCS_REPORT // Debug Print On
//================================================================================

namespace nw4r
{
namespace mcs
{

#if defined(WIN32)

    typedef BOOL (WINAPI* HIOReadType        )( u32 addr, void* buffer, s32 size );
    typedef BOOL (WINAPI* HIOWriteType       )( u32 addr, const void* buffer, s32 size );

#endif  // #if defined(WIN32)

#if !defined(NW4R_FINAL) || defined(NW4R_MCS_ENABLE)

class HioRingBuffer
{
#if defined(WIN32)

    public:
        static void         SetHIOFuncAddress(
                                HIOReadType     readFunc,
                                HIOWriteType    writeFunc);

    protected:
        static HIOReadType  mspfHIORead;
        static HIOWriteType mspfHIOWrite;

#endif  // #if defined(WIN32)

public:
    static const int    CmnMemBaseAddress   = 0x8000;
    static const int    CopyAlignment   = 32;

                        HioRingBuffer() {}

                        HioRingBuffer(
                            u32     bufOffset,
                            u32     size,
                            void*   tempBuf
                        )
                        {
                            Init(bufOffset, size, tempBuf);
                        }

    void                Init(
                            u32     baseOffset,
                            u32     size,
                            void*   tempBuf);

    void                InitBuffer();

    void                EnablePort()    { mEnablePort = true;  }
    void                DisablePort()   { mEnablePort = false; }
    bool                IsPort()        { return mEnablePort; }

    u32                 GetBufferSize() const   { return mBufferSize; }

    bool                Read(bool* pbAvailable);

    void*               GetMessage(
                            u32*    pChannel,
                            u32*    pTotalSize);

    bool                GetWritableBytes(
                            u32*    pBytes,
                            bool    withUpdate = true);

    bool                Write(
                            u32         channel,
                            const void* buf,
                            u32         size);

protected:
    bool                ReadSection_(
                            u32     offset,
                            void*   data,
                            u32     size);

    bool                WriteSection_(
                            u32         offset,
                            const void* data,
                            u32         size);

    bool                UpdateReadWritePoint_();
    bool                UpdateReadPoint_();
    bool                UpdateWritePoint_();

    u32                 mBaseOffset;        // 使用するバッファのオフセット
    u32                 mBufferSize;        // Headerを除いた実際に使用できるバッファのサイズ
    void*               mTempBuf;           // テンポラリ読み書きバッファ

    u32                 mReadPoint;         // 現在読み出すポイント
    u32                 mWritePoint;        // 現在書き込むポイント

    u32                 mProcBytes;         // テンポラリバッファ中の処理したバイト数
    u32                 mTransBytes;        // テンポラリバッファに転送しているバイト数

    bool                mEnablePort;        // USB2EXIがエラーなく使えているか。
    u8                  padding[3];         // warning対処

};

#endif  // #if !defined(NW4R_FINAL) || defined(NW4R_MCS_ENABLE)

}   // namespace mcs
}   // namespace nw4r

#endif  // #if defined(WIN32) || defined(NW4R_GC)

/* NW4R_MCS_HIORINGBUFFER_H_ */
#endif
