﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Nintendo.McsServer
{
    /// <summary>
    /// チャンネルごとのデータをあらわすクラス。
    /// DataPacketキューがRouterクラスに存在します。
    ///
    /// 各チャンネルは、(PC側アプリから送信された)ソケットからの
    /// 受信データをDataPacketに変換して、
    /// RouterクラスのDataPacketキューに登録します。
    ///
    /// RouterクラスのDataPacketキューに登録されたDataPacketは
    /// ICommDevice経由で通信対象へと送信されます。
    /// </summary>
    public class DataPacket
    {
        /// <summary>
        /// チャンネル番号
        /// </summary>
        public readonly ushort Channel;
        /// <summary>
        /// データ
        /// </summary>
        public readonly byte[] Data;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public DataPacket(ushort channel, byte[] data)
        {
            Channel = channel;
            Data = data;
        }

        /// <summary>
        /// DataPacketを生成します。
        /// </summary>
        public static DataPacket CopyAndCreate(ushort channel, byte[] data, int dataSize)
        {
            byte[] newData = new byte[dataSize];
            Array.Copy(data, newData, dataSize);
            return new DataPacket(channel, newData);
        }
    }
}
