﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

#include <autoTestAssistTool/HidInputerTypes.h>

// TODO: HidShellLibrary 以前の共有メモリマップアクセスのみで使用されている。
//       処理を HidShellLibrary へ統一するときに削除
const int ControllerIndexRange = 8;

const float DefaultStickRadius = (32767.0f);

typedef int32_t ControllerStickValueType;
typedef int32_t ControllerButtonValueType;

enum AbstractedPadDeviceType : int32_t
{
    AbstractedPadDeviceType_SwitchProController = 0,    // Switch Pro コントローラー
    AbstractedPadDeviceType_HandheldJoyLeft     = 2,    // 左ハンドヘルドジョイコン
    AbstractedPadDeviceType_HandheldJoyRight    = 3,    // 右ハンドヘルドジョイコン
    AbstractedPadDeviceType_JoyConLeft          = 4,    // 左ジョイコン
    AbstractedPadDeviceType_JoyConRight         = 5,    // 右ジョイコン
};

enum AbstractedPadInterfaceType : int32_t
{
    AbstractedPadInterfaceType_Bluetooth        = 1,    // Bluetooth
    AbstractedPadInterfaceType_Rail             = 2,    // 本体レール
    AbstractedPadInterfaceType_Usb              = 3,    // USB
};

enum AbstractedPadAttributeMask : uint32_t
{
    AbstractedPadAttribute_IsConnected              = 0x00000001u, // コントローラーが接続されているか否か
    AbstractedPadAttribute_IsEnableSixAxisSensor    = 0x00000002u, // 6軸センサーが有効か否か
};
