﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "common.h"
#include "ControllerOptions.h"
#include <exception>
#include <sstream>

class InvalidControllerIdException : public std::exception
{
private:
    int      m_InvalidControllerId;

public:
    explicit InvalidControllerIdException(int id) : std::exception()
    {
        m_InvalidControllerId = id;
    }
    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid controller was specified. controllerId=" << m_InvalidControllerId;
        return outputString.str();
    }

};


class InvalidButtonException : public std::exception
{
private:
    Button            m_InvalidButton;

public:
    explicit InvalidButtonException(Button type) : std::exception()
    {
        m_InvalidButton = type;
    }

    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid button was specified. buttonType=" << m_InvalidButton;
        return outputString.str();
    }
};

class InvalidStickException : public std::exception
{
private:
    Stick            m_InvalidStick;

public:
    explicit InvalidStickException(Stick type) : std::exception()
    {
        m_InvalidStick = type;
    }

    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid stick was specified. stickType=" << m_InvalidStick;
        return outputString.str();
    }
};

class InvalidControllerDeviceInofException : public std::exception
{
private:
    ControllerDeviceType m_DeviceType;
    ControllerInterfaceType m_InterfaceType;

public:
    explicit InvalidControllerDeviceInofException(
        ControllerDeviceType deviceType,
        ControllerInterfaceType interfaceType)
    {
        m_DeviceType = deviceType;
        m_InterfaceType = interfaceType;
    }

    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid device info was specified. deviceType=" << m_DeviceType
            << ", interfaceType=" << m_InterfaceType;
        return outputString.str();
    }
};
