﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "common.h"
#include "CaptureGrabber.h"
#include "CaptureProcessorException.h"
#include "ICapture.h"
#include <autoTestAssistTool/Common/autoTestAssistTool_LibTypes.h>

#include <map>
#include <thread>


class DirectshowCapture : public ICapture
{
public:
    DirectshowCapture(int deviceId, bool isPreview, CaptureResolution resolution);
    ~DirectshowCapture();

private:
    // キャプチャ
    void StartCapture();
    void EndCapture();
    void ResetCapture(int deviceId, bool isPreview, CaptureResolution resolution);
    void RunCapture();
    void Capture();

    // ウィンドウ情報
    std::string GetPreviewName();
    int GetOriginalPreviewWidth();
    int GetOriginalPreviewHeight();

    int             m_CaptureDeviceId;
    int             m_CaptureResolutionWidth;
    int             m_CaptureResolutionHeight;

    CaptureGrabber                  m_CaptureGrabber;
    std::unique_ptr<std::thread>    m_CaptureThread;

    // キャプチャ画像リスト
    std::map<ImageIdType, cv::Mat>    m_CaptureImageMap;
};
