﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <cstdio>
#include <cstring>
#include <map>
#include <nn/util/util_Optional.h>
#include <nn/nn_Result.h>
#include <nn/nn_Log.h>
#include <nn/nn_Common.h>

class Option
{
public:
    Option(int argc, char** argv)
    {
        for(int i = 1; i < argc; i++)
        {
            if(argv[i][0] == '-')
            {
                if(i + 1 >= argc || argv[i + 1][0] == '-')
                {
                    m_Map[argv[i]] = "";
                }
                else
                {
                    m_Map[argv[i]] = argv[i + 1];
                    i++;
                }
            }
        }
    }

    bool HasKey(const char* key) const
    {
        return m_Map.find(key) != m_Map.cend();
    }

    const char* GetValue(const char* key) const
    {
        auto it = m_Map.find(key);
        return it != m_Map.cend() ? (*it).second.c_str() : nullptr;
    }

private:
    std::map<std::string, std::string> m_Map;
};
