﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ShopMonitoringTool_SysFramework.h"
#include "ShopMonitoringTool_UiScene.h"

class LogScene : public Scene
{
public:
    const nn::util::Color4u8Type DefaultBgColor         = { {  10,  10,  10, 255 } };
    const nn::util::Color4u8Type ControllableBgColor    = { {  15,  15,  15, 255 } };
    const nn::util::Color4u8Type DebugLogColor          = { {  60,  60,  60, 255 } };
    const nn::util::Color4u8Type InfoLogColor           = { { 200, 200, 200, 255 } };
    const nn::util::Color4u8Type WarningLogColor        = { { 180, 120,  50, 255 } };
    const nn::util::Color4u8Type ErrorLogColor          = { { 200,  50,  50, 255 } };

    virtual ~LogScene();

    int m_DisplayLogLineStartPos = 0;
    const int DisplayLogLineSize = 25;
    const int LineOffset = 24;

    bool m_IsEnabledAutoScroll = false;

    void DisplayRangeUp();
    void DisplayRangeDown();
    void DisplayRangeReset();
    void SetEnabledAutoScroll(bool isEnabledAutoScroll);

    void Draw();
    void Update();
    void Control();
    std::string GetDescription();
};
