﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/result/result_HandlingUtility.h>
#include <nn/nifm.h>
#include <nn/ssl.h>
#include <nn/socket.h>

#include "ShopMonitoringTool_SysFramework.h"

class ExecuteItem
{
public:
    enum class ExecuteState
    {
        Unexecuted, //未実行
        Processing, //実行中
        Succeeded,  //成功
        Failed,     //失敗
    };
private:
    std::string m_TaskName;
    std::string m_Description;
    ExecuteState m_ExecuteState;
public:
    ExecuteItem();
    NN_IMPLICIT ExecuteItem(std::string name);
    ExecuteItem(std::string name, std::string description);
    std::function<nn::Result(bool*)> function;
    void ResetState();
    const char* GetName();
    std::string GetDescription();
    void SetDescription(std::string description);
    ExecuteState GetState();
    nn::Result NetworkExecute(bool* pOutValue);
    nn::Result Execute(bool* pOutValue);
};
