﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * インクルード
 */
#include "QREL.h"

/****************************************************************
 * 外部関数
 ****************************************************************/
/*
 * 関数名 QREL_CalcChainParity
 * 機能   連結シンボルのパリティデータを計算する
 * 引数   userdata(IN)            ユーザデータへのポインタ
 *        parity(OUT)             パリティデータ格納領域のポインタ
 * 戻り値 常に0以外を返す
 * 説明   連結シンボルのパリティデータを計算する。
 */
bool QREL_CalcChainParity(USERDATA *userdata, uint8_t *parity)
{
    int32_t i;

    QREL_SetLastError(ERR_NOERROR, true);

    *parity = 0;
    for (i = 0; i < userdata->length; i++)
    {
        *parity ^= userdata->data[i];
    }
    *parity &= 0x00ff;

    return true;
}
