﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <cstdint>
#include <nn/ncm/ncm_SubmissionPackageInstallTask.h>
#include <nn/ns/ns_ApplicationVerificationApi.h>

namespace PreinstallAppWriter
{

struct InstallProgress
{
    int installedCount;
    int totalCount;
    int64_t currentSize;
    int64_t installedSize;
    int64_t totalSize;
};

struct VerifyProgress
{
    int verifiedCount;
    int totalCount;
    int64_t currentSize;
    int64_t verifiedSize;
    int64_t totalSize;
};

class ReadOnlyProgressInfo
{
public:
    ReadOnlyProgressInfo();
    int GetInstalledCount();
    int GetInstallTotalCount();
    int64_t GetCurrentInstallSize();
    int64_t GetInstalledSize();
    int64_t GetInstallTotalSize();

    int GetVerifiedCount();
    int GetVerifyTotalCount();
    int64_t GetCurrentVerifySize();
    int64_t GetVerifiedSize();
    int64_t GetVerifyTotalSize();

    nn::ncm::InstallThroughput GetInstallThroughput();

protected:
    int64_t GetCurrentInstallSizeInternal();
    int64_t GetCurrentVerifySizeInternal();

    InstallProgress m_InstallProgress;
    VerifyProgress m_VerifyProgress;

    nn::ncm::SubmissionPackageInstallTask* m_pTask;
    nn::ns::AsyncVerifyApplicationProgress* m_pVerifyProgress;
    nn::os::Mutex m_Lock;
};

class ProgressInfo : public ReadOnlyProgressInfo
{
public:
    void SetInstallTask(nn::ncm::SubmissionPackageInstallTask* task);
    void SetInstallStatus(nn::ncm::SubmissionPackageInstallTask* task, int installedCount, int64_t installedSize, int64_t currentInstallSize);
    void SetInstalledCount(int count);
    void SetInstallTotalCount(int count);
    void SetCurrentInstallSize(int64_t size);
    void SetInstalledSize(int64_t size);
    void SetInstallTotalSize(int64_t size);

    void SetAsyncProgress(nn::ns::AsyncVerifyApplicationProgress* progress);
    void SetVerifyStatus(nn::ns::AsyncVerifyApplicationProgress* progress, int verifiedCount, int64_t verifiedSize, int64_t currentVerifySize);
    void SetVerifiedCount(int count);
    void SetVerifyTotalCount(int count);
    void SetCurrentVerifySize(int64_t size);
    void SetVerifiedSize(int64_t size);
    void SetVerifyTotalSize(int64_t size);

    static void Func(void* self);
    void UpdateProgress(void* p);

};

}
