﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "NoftWriter_Window.h"

namespace noftwriter { namespace ui {

/**
 * @brief   メッセージを表示するウィンドウです。
 */
class MessageBox : public Window
{
public:
    /**
     * @brief   メッセージボックスに表示するアイコンです。
     */
    enum class Icon
    {
        None,
        Information,
        Error
    };

public:
    MessageBox() NN_NOEXCEPT :
        m_Icon(Icon::Information),
        m_Text(nullptr)
    {}

    /**
     * @brief   表示するアイコンを設定します。
     */
    void SetIcon(Icon icon) NN_NOEXCEPT
    {
        m_Icon = icon;
    }

    /**
     * @brief   表示する文字列を設定します。
     */
    void SetText(const char* text) NN_NOEXCEPT
    {
        m_Text = text;
    }

    virtual void UpdateInput(const npad::INpadController& controller) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
     * @brief   アイコンを描画します。
     */
    void DrawIcon(float x, float y, float size) NN_NOEXCEPT;

private:
    Icon        m_Icon;     //!< アイコン
    const char* m_Text;     //!< 表示する文字列
};

}}  // noftwriter::ui
