﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>
#include <nn/hid/hid_Npad.h>

#include "NoftWriter_Window.h"

namespace noftwriter { namespace ui {

/**
 * @brief   接続されているデバイスの一覧を表示するウィンドウです。
 */
class DeviceListWindow : public Window
{
public:
    DeviceListWindow() NN_NOEXCEPT :
        m_ActiveNpadId(InvalidNpadId)
    {}

    /**
     * @brief   アクティブな NpadId を設定
     */
    void SetActiveNpadId(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT
    {
        m_ActiveNpadId = npadId;
    }

    /**
     * @brief   アクティブな NpadId をクリア
     */
    void ClearActiveNpadId() NN_NOEXCEPT
    {
        m_ActiveNpadId = InvalidNpadId;
    }

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    static const nn::hid::NpadIdType InvalidNpadId;

private:
    void PrintDeviceList(float x, float y, float width, float height) NN_NOEXCEPT;
    void PrintIndicator(float x, float y, int idIndex) NN_NOEXCEPT;

private:
    nn::hid::NpadIdType m_ActiveNpadId;
};

}}  // noftwriter::ui
