﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "NandVerifier_PartitionDefinitions.h"
#include "NandVerifier_HashList.h"
#include "NandVerifier_Viewer.h"

class VerifyScene : public glv::GLV
{
private:
    HashList** m_ppHashList;
    Viewer* m_Viewer;
    glv::Label* m_Status;

    void Load() NN_NOEXCEPT;
    void Dump() NN_NOEXCEPT;
    void Settings() NN_NOEXCEPT;
    void Verify(std::string path) NN_NOEXCEPT;

    nn::Result LoadAnswerFileFromRom(const char* path) NN_NOEXCEPT;
    nn::Result LoadAnswerFileFromSdCard(const char* path) NN_NOEXCEPT;
    nn::Result LoadAnswerFileImpl(const char* path) NN_NOEXCEPT;
    nn::Result LoadFileListFromRom() NN_NOEXCEPT;
    nn::Result LoadFileListFromSdCard() NN_NOEXCEPT;
    nn::Result LoadFileListImpl() NN_NOEXCEPT;

    nn::Result DumpImpl(std::string& str) NN_NOEXCEPT;


public:
    explicit VerifyScene(HashList** ppInHashList) NN_NOEXCEPT;

};
