﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Macro.h>

#include <nn/manu/manu_Api.h>

namespace
{
    const size_t BufSize = 2048;
    uint8_t buffer[BufSize];

    nn::Result UsbLoopBack()
    {
        size_t readSize = 0;
        NN_RESULT_DO(nn::manu::UsbRead(&readSize, buffer, BufSize, BufSize));
        NN_LOG("Usb Read  (size:%d)\n",readSize);

        size_t writeSize = 0;
        NN_RESULT_DO(nn::manu::UsbWrite(&writeSize, buffer, BufSize, readSize));
        NN_LOG("Usb Write (size:%d)\n",writeSize);

        NN_RESULT_SUCCESS;
    }
}

extern "C" void nninitStartup() NN_NOEXCEPT
{
}

extern "C" void nndiagStartup() NN_NOEXCEPT
{
}

extern "C" void nnMain()
{
    NN_LOG("UsbLoopBack\n");

    nn::manu::InitializeUfio();

    for(int i=0;i<100;i++)
        UsbLoopBack();

}
