﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "VibrationDemo_SceneUi.h"
#include "VibrationDemo.h"

namespace VibrationDemo
{
    SceneUi::SceneUi()
    {
        VibrationSource<nn::hid::VibrationPlayer>* pSources[] =
        {
            &m_VibrationSourcesForLeft[0],
            &m_VibrationSourcesForLeft[1],
            &m_VibrationSourcesForRight[0],
            &m_VibrationSourcesForRight[1]
        };

        // ボタン
        std::pair<const char*, nn::util::Float2> buttonInfo[] =
        {
            std::make_pair("Vibration Button 1", nn::util::MakeFloat2(50, 200)),
            std::make_pair("Vibration Button 2", nn::util::MakeFloat2(350, 200))
        };
        for (size_t i = 0; i < NN_ARRAY_SIZE(buttonInfo); ++i)
        {
            m_FirstItemGroup.Add(new VibrationButton());
            VibrationButton& obj = *(VibrationButton*)(m_FirstItemGroup.GetItemSet().back());
            obj.Setup(buttonInfo[i].second.x, buttonInfo[i].second.y, 200.f, 64.f, nullptr, buttonInfo[i].first);
            obj.SetEffectColor(Color::Green);
            obj.SetTextColor(Color::Blue);
            obj.ThroughCancel(true);
            obj.OnOffMode(false);
            obj.SetVibrationSources(pSources, NN_ARRAY_SIZE(pSources));
            // カーソル移動
            obj.SetVibration(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.bnvib", 0.5f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.wav", 0.5f);
            // ボタン押下げ
            obj.SetVibration(nns::hidfw::layout::LayoutState::Selected::Mask, "ButtonDown.bnvib", 0.4f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Selected::Mask, "Select.wav", 0.8f);
        }
        m_FirstItemGroup.FocusItem(0);
        m_FirstItemGroup.Focus(true);

        // スライダー
        buttonInfo[0] = std::make_pair("", nn::util::MakeFloat2(50, 408));
        buttonInfo[1] = std::make_pair("", nn::util::MakeFloat2(350, 408));
        for (size_t i = 0; i < NN_ARRAY_SIZE(buttonInfo); ++i)
        {
            m_ScondItemGroup.Add(new VibrationSeekBar());
            VibrationSeekBar& obj = *(VibrationSeekBar*)(m_ScondItemGroup.GetItemSet().back());
            obj.Setup(buttonInfo[i].second.x, buttonInfo[i].second.y, 200.f, 16.f, nullptr, buttonInfo[i].first);
            obj.SetMainColor(Color::Green);
            obj.SetTextColor(Color::Black);
            obj.OnOffMode(false);
            obj.SetVibrationSources(pSources, NN_ARRAY_SIZE(pSources));
            // カーソル移動
            obj.SetVibration(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.bnvib", 0.5f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.wav", 0.5f);
            // アイテム選択
            obj.SetVibration(nns::hidfw::layout::LayoutState::Selected::Mask, "Select.bnvib", 1.f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Selected::Mask, "Select.wav", 0.5f);
            // 選択解除
            obj.SetVibration(nns::hidfw::layout::LayoutState::Canceled::Mask, "Cancel.bnvib", 1.f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Canceled::Mask, "Cancel.wav", 0.4f);
            // 値の更新
            obj.SetVibration(nns::hidfw::layout::LayoutState::UpdateValue::Mask, "UpdateValue.bnvib", 0.15f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::UpdateValue::Mask, "UpdateValueForSlider.wav", 0.275f);
            // 限界値
            obj.SetVibration(nns::hidfw::layout::LayoutState::LimitingValue::Mask, "Limit.bnvib", 0.65f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::LimitingValue::Mask, "LimitValueForSlider.wav", 0.8f);
        }
        static_cast<VibrationSeekBar*>(m_ScondItemGroup.GetItemSet().back())->SetLimiterSpan(50);
        m_ScondItemGroup.FocusItem(0);

        // ノブ
        buttonInfo[0] = std::make_pair("", nn::util::MakeFloat2(690, 172));
        buttonInfo[1] = std::make_pair("", nn::util::MakeFloat2(990, 172));
        for (size_t i = 0; i < NN_ARRAY_SIZE(buttonInfo); ++i)
        {
            m_FirstItemGroup.Add(new VibrationKnob());
            VibrationKnob& obj = *(VibrationKnob*)(m_FirstItemGroup.GetItemSet().back());
            obj.Setup(buttonInfo[i].second.x, buttonInfo[i].second.y, 128, 128, nullptr, buttonInfo[i].first);
            obj.SetTextColor(Color::Black);
            obj.OnOffMode(false);
            obj.SetVibrationSources(pSources, NN_ARRAY_SIZE(pSources));
            // カーソル移動
            obj.SetVibration(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.bnvib", 0.5f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.wav", 0.5f);
            // アイテム選択
            obj.SetVibration(nns::hidfw::layout::LayoutState::Selected::Mask, "Select.bnvib", 1.f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Selected::Mask, "Select.wav", 0.5f);
            // 選択解除
            obj.SetVibration(nns::hidfw::layout::LayoutState::Canceled::Mask, "Cancel.bnvib", 1.f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Canceled::Mask, "Cancel.wav", 0.4f);
            // 値の更新
            obj.SetVibration(nns::hidfw::layout::LayoutState::UpdateValue::Mask, "UpdateValue.bnvib", 0.2f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::UpdateValue::Mask, "UpdateValueForKnob.wav", 0.275f);
            // 限界値
            obj.SetVibration(nns::hidfw::layout::LayoutState::LimitingValue::Mask, "Limit.bnvib", 0.55f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::LimitingValue::Mask, "LimitValueForKnob.wav", 0.65f);
        }
        static_cast<VibrationKnob*>(m_FirstItemGroup.GetItemSet().back())->SetMaxValue(5);
        static_cast<VibrationKnob*>(m_FirstItemGroup.GetItemSet().back())->SetValue(0);

        // スイッチ
        buttonInfo[0] = std::make_pair("", nn::util::MakeFloat2(698, 400));
        buttonInfo[1] = std::make_pair("", nn::util::MakeFloat2(998, 400));
        for (size_t i = 0; i < NN_ARRAY_SIZE(buttonInfo); ++i)
        {
            m_ScondItemGroup.Add(new VibrationSwitch());
            VibrationSwitch& obj = *(VibrationSwitch*)(m_ScondItemGroup.GetItemSet().back());
            obj.Setup(buttonInfo[i].second.x, buttonInfo[i].second.y, 96, 32, nullptr, buttonInfo[i].first);
            obj.SetTextColor(Color::Black);
            obj.ThroughCancel(true);
            obj.OnOffMode(false);
            obj.SetVibrationSources(pSources, NN_ARRAY_SIZE(pSources));
            // カーソル移動
            obj.SetVibration(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.bnvib", 0.5f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Hover::Mask, "Move.wav", 0.5f);
            // 値の切り替え
            obj.SetVibration(nns::hidfw::layout::LayoutState::Selected::Mask, "Switch.bnvib", 0.55f);
            obj.SetSoundEffect(nns::hidfw::layout::LayoutState::Selected::Mask, "SwitchValue.wav", 0.6f);
        }

        // 前後関係
        m_FirstItemGroup.SetPrevItemSet(&m_ScondItemGroup);
        m_FirstItemGroup.SetNextItemSet(&m_ScondItemGroup);
        m_ScondItemGroup.SetPrevItemSet(&m_FirstItemGroup);
        m_ScondItemGroup.SetNextItemSet(&m_FirstItemGroup);
    } // NOLINT(impl/function_size)

    void SceneUi::Initialize() NN_NOEXCEPT
    {
        m_IsExit = false;
        m_SceneResult = false;
        gTextWriter.SetCursor(0, 0);
        gTextWriter.SetScale(1.f, 1.f);
        gTextWriter.SetTextColor(Color::White);
        gDrawer.SetClearColor(Color::Black);
        gDrawer.SetColor(Color::White);

        gVibrationManager.DisconnectAll();

        m_VibrationSourcesForLeft[0].Connection(nn::hid::NpadId::Handheld, nn::hid::NpadJoyDeviceType_Left);
        m_VibrationSourcesForLeft[1].Connection(nn::hid::NpadId::No1, nn::hid::NpadJoyDeviceType_Left);
        m_VibrationSourcesForRight[0].Connection(nn::hid::NpadId::Handheld, nn::hid::NpadJoyDeviceType_Right);
        m_VibrationSourcesForRight[1].Connection(nn::hid::NpadId::No1, nn::hid::NpadJoyDeviceType_Right);

        for (auto itr : gController.GetControllerList())
        {
            gController.GetController(itr->GetNpadId())->StartSixAxisSensor();
        }

        m_IsEnableVibration = true;
        gVibrationManager.EnableVibration();

        m_IsShowVibration = true;
    }

    void SceneUi::Finalize() NN_NOEXCEPT
    {
        gVibrationManager.DisconnectAll();

        for (auto itr : gController.GetControllerList())
        {
            gController.GetController(itr->GetNpadId())->StopSixAxisSensor();
        }
    }

    void SceneUi::Update() NN_NOEXCEPT
    {
        m_FirstItemGroup.Update();
        m_ScondItemGroup.Update();

        nn::hid::NpadIdType useNpadId = gControllerSequenceManager.GetMasterControllerId();

        if (gController.GetController(useNpadId)->IsTrigger(nn::hid::NpadButton::R::Mask))
        {
            m_IsEnableVibration = false;
            gVibrationManager.DisableVibration();
        }
        else if (gController.GetController(useNpadId)->IsTrigger(nn::hid::NpadButton::L::Mask))
        {
            m_IsEnableVibration = true;
            gVibrationManager.EnableVibration();
        }

        if (gController.GetController(useNpadId)->IsTrigger(nn::hid::NpadButton::Plus::Mask))
        {   // タイトルに戻る
            //gApplicationState.SetScene(Scene::Title);
            //ExitScene();
        }
    }

    void SceneUi::Draw() NN_NOEXCEPT
    {
        gDrawer.SetColor(Color::White);

        gFont.SetSize(36);
        gFont.SetPos( 8.f, 8.f);
        gFont.Print("UI Demo\n");

        gFont.SetSize(14);
        gFont.SetPos(8.f, 56.f);
        gDrawer.SetColor(Color::White);

        if (m_IsEnableVibration)
        {
            gFont.SetPos(gFont.GetPosX() + nn::util::CosEst(nn::util::DegreeToRadian((m_FrameCount % 6) * 60.0f)) * 2.f, gFont.GetPosY());
        }
        gFont.Print("%s", gControllerSequenceManager.GetMasterControllerId() == nn::hid::NpadId::Handheld ? "" : "");

        gFont.SetPosX(32.f);
        gFont.Print("Vibration :    ");

        auto pos = gFont.GetPosX();
        gDrawer.SetColor(m_IsEnableVibration ? Color::Green : Color::DarkGray);
        gFont.Print("    Enable　　");
        gDrawer.SetColor(Color::Gray);
        gFont.Print(" ／     ");
        gDrawer.SetColor(m_IsEnableVibration ? Color::DarkGray : Color::NintendoRed);
        pos = m_IsEnableVibration ? pos : gFont.GetPosX();
        gFont.Print("    Disable");
        gFont.SetPosX(pos);
        gDrawer.SetColor(m_IsEnableVibration ? Color::Green : Color::NintendoRed);
        gFont.Print("\n");

        gDrawer.SetColor(Color::White);
        gDrawer.Draw2DLine(nn::util::MakeFloat2(0.f, gFont.GetPosY() + 8.f), nn::util::MakeFloat2(1280.f, gFont.GetPosY() + 8.f));

        gDrawer.SetColor(Color::White);
        gFont.SetPos(50.f, 130.f);
        gFont.Print("Button");
        gFont.SetPosX(690.f);
        gFont.Print("Knob");

        gFont.SetPos(50.f, 335.f);
        gFont.Print("Slider");
        gFont.SetPosX(690.f);
        gFont.Print("Switch");
        gFont.DrawText();

        m_FirstItemGroup.Draw();
        m_ScondItemGroup.Draw();
    }
}
