﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Button.h"

namespace VibrationCollection
{
    int g_ButtonCount = 10;
    int g_BnvibButtonStartIndex = 0;
    int g_AudioButtonStartIndex = 0;
    int g_SelectedBnvibButtonInedx = 0;
    int g_SelectedAudioButtonIndex = 0;

    nns::hidfw::layout::ButtonGroup g_ButtonGroup[ApplicationButtonGroup_Num];

    void InitializeMainButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pButtonGroup);

        static const nn::util::Float2 basePos = NN_UTIL_FLOAT_2_INITIALIZER(48.f, 520.f);
        static const nn::util::Float2 margin = NN_UTIL_FLOAT_2_INITIALIZER(0.f, 72.f);
        static const nn::util::Float2 size = NN_UTIL_FLOAT_2_INITIALIZER(324.f, 56.f);

        const char* buttonText[] =
        {
            "Vibration Setting",
            "Play Vibration"
        };

        nns::hidfw::layout::LayoutFunction pFunc[] =
        {
            ShowSetting,
            PlayVibration
        };

        nn::util::Color4u8 buttonColor[] =
        {
            nn::util::Color4u8(232, 57, 54, 255),
            nn::util::Color4u8(49, 119, 125, 255),
        };

        nn::util::Float2 pos = basePos;

        // 標準的なボタンの設定で作成します
        for (size_t i = 0; i < NN_ARRAY_SIZE(buttonText); ++i)
        {
            nns::hidfw::layout::Button button;
            button.SetPos(pos.x, pos.y);
            button.SetSize(size.x, size.y);
            button.SetText(buttonText[i]);
            button.SetFunc(pFunc[i]);
            button.SetTextColor(nn::util::Color4u8::White());
            button.ThroughCancel(true);                             // キャンセルを無効化します
            button.SetMainColor(buttonColor[i]);
            button.OnOffMode(false);
            pButtonGroup->Add(new nns::hidfw::layout::Button(button));

            pos.x += margin.x;
            pos.y += margin.y;
        }
        pButtonGroup->SetOrientation(nns::hidfw::layout::ButtonGroup::eOrientation_Vertical);

        InitializeVibrationSettingSeekBar(g_DialogSeekBar);
    }

    void InitializeFileButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pButtonGroup);
        static const nn::util::Float2 basePos = NN_UTIL_FLOAT_2_INITIALIZER(1044.f, 32.f);
        static const nn::util::Float2 margin = NN_UTIL_FLOAT_2_INITIALIZER(76.f, 0.f);

        static const nn::util::Float2 size[] =
        {
            NN_UTIL_FLOAT_2_INITIALIZER(64.f, 32.f),
            NN_UTIL_FLOAT_2_INITIALIZER(128.f, 32.f)
        };

        const char* buttonText[] =
        {
            "Open",
            "ReLoad"
        };

        nn::util::Float2 pos = basePos;

        for (size_t i = 0; i < NN_ARRAY_SIZE(buttonText); ++i)
        {
            nns::hidfw::layout::Button button;
            button.SetPos(pos.x, pos.y);
            button.SetSize(size[i].x, size[i].y);
            button.SetText(buttonText[i]);
            button.ThroughCancel(true);                             // キャンセルを無効化します
            button.OnOffMode(false);
            if (i == 1)
            {
                button.SetTextColor(nn::util::Color4u8::White());
                button.SetMainColor(nn::util::Color4u8(232, 57, 54, 255));
                button.SetFunc(ReloadButton);
            }
            else
            {
                button.SetFunc(DirectorySelectButton);
            }
            pButtonGroup->Add(new nns::hidfw::layout::Button(button));

            pos.x += margin.x;
            pos.y += margin.y;
        }
        pButtonGroup->SetOrientation(nns::hidfw::layout::ButtonGroup::eOrientation_Horizontal);
    }

    void InitializeVibrationButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pButtonGroup);

        static const nn::util::Float2 basePos = NN_UTIL_FLOAT_2_INITIALIZER(444.f, 176.f);
        static const nn::util::Float2 margin = NN_UTIL_FLOAT_2_INITIALIZER(0.f, 48.f);
        static const nn::util::Float2 size = NN_UTIL_FLOAT_2_INITIALIZER(370.f, 48.f);

        nn::util::Float2 pos = basePos;

        for (int i = 0; i < g_ButtonCount; ++i)
        {
            nns::hidfw::layout::Button button;
            button.SetPos(pos.x, pos.y);
            button.SetSize(size.x, size.y);
            button.SetText("");
            button.ThroughCancel(true);
            button.MultiMode(false);
            button.OnOffMode(false);
            button.ImmediateExecute(true);
            button.SetFunc(PlayVibrationButton);
            pButtonGroup->Add(new nns::hidfw::layout::Button(button));

            pos.x += margin.x;
            pos.y += margin.y;
        }
        nns::hidfw::layout::BaseItem::ChoiceModeSet choice;
        choice.Reset();
        choice.Set<nns::hidfw::layout::BaseItem::ChoiceMode::Controller>();

        nns::hidfw::layout::Button button;
        button.SetText("");
        button.ThroughCancel(true);
        button.SetChooseMode(choice);
        button.MultiMode(false);

        pButtonGroup->Add(new nns::hidfw::layout::Button(button));
        pButtonGroup->Add(new nns::hidfw::layout::Button(button));

        pButtonGroup->SetOrientation(nns::hidfw::layout::ButtonGroup::eOrientation_Vertical);
    }

    void InitializeAudioButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pButtonGroup);

        static const nn::util::Float2 basePos = NN_UTIL_FLOAT_2_INITIALIZER(862.f, 176.f);
        static const nn::util::Float2 margin = NN_UTIL_FLOAT_2_INITIALIZER(0.f, 48.f);
        static const nn::util::Float2 size = NN_UTIL_FLOAT_2_INITIALIZER(370.f, 48.f);

        nn::util::Float2 pos = basePos;

        // 標準的なボタンの設定で作成します
        for (int i = 0; i < g_ButtonCount; ++i)
        {
            nns::hidfw::layout::Button button;
            button.SetPos(pos.x, pos.y);
            button.SetSize(size.x, size.y);
            button.SetText("");
            button.ThroughCancel(true);
            button.MultiMode(false);
            button.OnOffMode(false);
            button.ImmediateExecute(true);
            button.SetFunc(SelectAudioFile);
            pButtonGroup->Add(new nns::hidfw::layout::Button(button));

            pos.x += margin.x;
            pos.y += margin.y;
        }

        nns::hidfw::layout::BaseItem::ChoiceModeSet choice;
        choice.Reset();
        choice.Set<nns::hidfw::layout::BaseItem::ChoiceMode::Controller>();

        nns::hidfw::layout::Button button;
        button.SetText("");
        button.ThroughCancel(true);
        button.SetChooseMode(choice);
        button.MultiMode(false);

        pos.x += margin.x + 500.f;
        pos.y += margin.y;
        button.SetPos(pos.x, pos.y);
        pButtonGroup->Add(new nns::hidfw::layout::Button(button));
        button.SetPos(basePos.x + 500.f, basePos.y);
        pButtonGroup->Add(new nns::hidfw::layout::Button(button));

        pButtonGroup->SetOrientation(nns::hidfw::layout::ButtonGroup::eOrientation_Vertical);
    }

    void InitializeVibrationViewer(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pButtonGroup);
        nns::hidfw::layout::LineChart* pVibrationLineChart = new nns::hidfw::layout::LineChart();
        pVibrationLineChart->SetDefault();
        pVibrationLineChart->AddElement(nns::hidfw::layout::LineChart::CreateElement(nn::util::Color4u8(16, 96, 242, 255), "Low", 160, 1.f, 0.f, 2.f));
        pVibrationLineChart->AddElement(nns::hidfw::layout::LineChart::CreateElement(nn::util::Color4u8::Red(), "Hi", 160, 1.f, 0.f, 2.f));
        pVibrationLineChart->SetChooseMode(nns::hidfw::layout::BaseItem::ChoiceMode::None::Mask);       // コントローラとタッチ操作を受け付けません
        pVibrationLineChart->SetPos(50, 160);
        pVibrationLineChart->SetSize(320, 160);
        pVibrationLineChart->SetMainColor(nn::util::Color4u8(42, 66, 77, 255));
        pVibrationLineChart->SetBorderColor(nn::util::Color4u8(0, 32, 0, 255));
        pVibrationLineChart->ThroughSelect(true);
        pButtonGroup->Add(pVibrationLineChart);

        nns::hidfw::layout::BarChart* pVibrationBarChart = new nns::hidfw::layout::BarChart();
        pVibrationBarChart->SetDefault();
        pVibrationBarChart->SetViewerMode(nns::hidfw::layout::BarChart::ViewerMode_Music);             // 音楽モード (エフェクトが付きます)
        pVibrationBarChart->SetMaxHorizontalValue(400.f);                                       // 周波数の Max を 400Hz に
        pVibrationBarChart->SetMinHorizontalValue(80.f);                                        // 周波数の Min を 80Hz  に
        pVibrationBarChart->SetMaxVerticalValue(1.f);                                           // Max Gain を 1.0f に
        pVibrationBarChart->SetMinVerticalValue(0.f);                                           // Min Gain を 0.f  に
        pVibrationBarChart->SetDivisionCount(64);                                               // 周波数のMin～Maxを64分割して表示します
        pVibrationBarChart->SetChooseMode(nns::hidfw::layout::BaseItem::ChoiceMode::None::Mask);       // コントローラとタッチ操作を受け付けません
        pVibrationBarChart->SetPos(50, 336);
        pVibrationBarChart->SetSize(320, 160);
        pVibrationBarChart->ThroughSelect(true);
        pVibrationBarChart->SetMainColor(nn::util::Color4u8(42, 66, 77, 255));
        pVibrationBarChart->SetBorderColor(nn::util::Color4u8(0, 32, 0, 255));
        pButtonGroup->Add(pVibrationBarChart);
    }

    void DirectorySelectButton(void* pushButton, void* param) NN_NOEXCEPT
    {
        NN_UNUSED(pushButton);
        NN_UNUSED(param);

        ShowOpenDirectoryDialog(nullptr, nullptr);
    }

    void ReloadButton(void* pushButton, void* param) NN_NOEXCEPT
    {
        NN_UNUSED(pushButton);
        NN_UNUSED(param);

        gFileManager.UnloadAudio();
        gFileManager.UnloadBnvib();

        Reload(nullptr, nullptr);
    }

    void PlayVibrationButton(void* pushButton, void* param) NN_NOEXCEPT
    {
        auto focusIndex = g_ButtonGroup[ApplicationButtonGroup_Vibration].GetFocusItemIndex();
        // 項目のスクロール用にボタンが余分に確保されているため、当該のボタンにフォーカスが合っている場合は補正を行います
        focusIndex =
            (focusIndex == g_ButtonCount) ? g_ButtonCount - 1 :
            (focusIndex == g_ButtonCount + 1) ? 0 :
            focusIndex;
        g_SelectedBnvibButtonInedx = g_BnvibButtonStartIndex + focusIndex;
        PlayVibration(pushButton, param);
    }

    void SelectAudioFile(void* pushButton, void* param) NN_NOEXCEPT
    {
        auto focusIndex = g_ButtonGroup[ApplicationButtonGroup_Audio].GetFocusItemIndex();
        // 項目のスクロール用にボタンが余分に確保されているため、当該のボタンにフォーカスが合っている場合は補正を行います
        focusIndex =
            (focusIndex == g_ButtonCount) ? g_ButtonCount - 1 :
            (focusIndex == g_ButtonCount + 1) ? 0 :
            focusIndex;
        g_SelectedAudioButtonIndex = g_AudioButtonStartIndex + focusIndex;
        PlayVibration(pushButton, param);
    }

    void CloseButtonFunc(void* pushButton, void* param) NN_NOEXCEPT
    {
        NN_UNUSED(pushButton);
        NN_ASSERT_NOT_NULL(param);

        nns::hidfw::layout::Dialog* pDialog = (nns::hidfw::layout::Dialog*)param;
        pDialog->CloseDialog();
    }
}
