﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/hid/hid_ControllerSupport.h>
#include <nn/swkbd/swkbd_Api.h>

#include "hidfw/gfx.h"
#include "hidfw/hid.h"
#include "hidfw/layout.h"

#include "SpeedChangeableVibrationPlayer.h"

#ifdef NN_SDK_BUILD_RELEASE
#define TT_LOG(...)
#else
#define TT_LOG NN_LOG
#endif

namespace VibrationCollection
{
    extern std::string g_HostRootPath;
    extern std::string g_SdRootPath;

    struct VibrationTarget
    {
        static const int MaxTargetCount = 4;                                // NpadId::No1 と NpadId::Handheld の振動子の最大個数
        nn::hid::VibrationNodeConnection Connection[MaxTargetCount];
        nn::hid::VibrationTarget         VibrationTarget[MaxTargetCount];
    };

    class ApplicationHeap
    {
        NN_DISALLOW_COPY(ApplicationHeap);
        NN_DISALLOW_MOVE(ApplicationHeap);

    private:
        void* m_pMemoryHeap;
        nn::mem::StandardAllocator m_ApplicationHeapHandle;

    public:
        ApplicationHeap() NN_NOEXCEPT
            : m_pMemoryHeap(0)
        {
        }

        void Initialize(size_t size) NN_NOEXCEPT
        {
            m_pMemoryHeap = new nn::Bit8[size];
            m_ApplicationHeapHandle.Initialize(m_pMemoryHeap, size);
        }

        void Finalize() NN_NOEXCEPT
        {
            m_ApplicationHeapHandle.Finalize();
            delete[] reinterpret_cast<nn::Bit8*>(m_pMemoryHeap);
        }

        void* Allocate(size_t size, size_t alignment) NN_NOEXCEPT
        {
            return m_ApplicationHeapHandle.Allocate(size, alignment);
        }

        void* Allocate(size_t size) NN_NOEXCEPT
        {
            return this->Allocate(size, sizeof(void*));
        }

        void Deallocate(void* ptr) NN_NOEXCEPT
        {
            if (ptr != 0)
            {
                m_ApplicationHeapHandle.Free(ptr);
            }
        }

        void* GetMemoryHeap() NN_NOEXCEPT
        {
            return m_pMemoryHeap;
        }
    };
}
