﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   テキストラベルに指定可能な文字列の最大長です。終端文字を含みます。
 */
const int LabelTextLengthMax = 128;

/**
 * @brief   テキストラベルを扱うクラスです。
 */
class Label :
    public DisplayObject
{
    NN_DISALLOW_COPY(Label);
    NN_DISALLOW_MOVE(Label);

public:
    Label() NN_NOEXCEPT;

    void SetText(const char* text) NN_NOEXCEPT;

    void SetText(const uint32_t* text) NN_NOEXCEPT;

    float GetTextSize() const NN_NOEXCEPT
    {
        return m_TextSize;
    }

    void SetTextSize(float size) NN_NOEXCEPT
    {
        m_TextSize = size;
    }

    void GetColor(Color* pOutColor) const NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pOutColor);

        *pOutColor = m_Color;
    }

    void SetColor(const Color& color) NN_NOEXCEPT
    {
        m_Color = color;
    }

    void GetShadowColor(Color* pOutColor) const NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pOutColor);

        *pOutColor = m_ShadowColor;
    }

    void SetBackgroundColor(const Color& color) NN_NOEXCEPT
    {
        m_BackgroundColor = color;
    }

    void GetBackgroundColor(Color* pOutColor) const NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pOutColor);

        *pOutColor = m_BackgroundColor;
    }

    void SetShadowColor(const Color& color) NN_NOEXCEPT
    {
        m_ShadowColor = color;
    }

    Point2D GetPadding() const NN_NOEXCEPT
    {
        return m_Padding;
    }

    void GetPadding(Point2D* pOutPadding) const NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pOutPadding);

        *pOutPadding = m_Padding;
    }

    void SetPadding(const Point2D& padding) NN_NOEXCEPT
    {
        m_Padding = padding;
    }

    void SetPadding(float x, float y) NN_NOEXCEPT
    {
        SetPadding({ { x, y } });
    }

    bool IsShadowEnabled() const NN_NOEXCEPT
    {
        return m_IsShadowEnabled;
    }

    void SetShadowEnabled(bool isEnabled) NN_NOEXCEPT
    {
        m_IsShadowEnabled = isEnabled;
    }

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    uint32_t    m_Text[LabelTextLengthMax]; //!< 表示する文字列
    float       m_TextSize;                 //!< 文字の描画サイズ
    Color       m_Color;                    //!< 文字色
    Color       m_ShadowColor;              //!< 影色
    Color       m_BackgroundColor;          //!< 背景色
    Point2D     m_Padding;                  //!< パディング
    bool        m_IsShadowEnabled;          //!< 影描画
};

}}}  // nns::sgx::gui
