﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <mutex>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx.h"
#include "SimpleGfx_GuiCursorLink.h"

namespace nns { namespace sgx { namespace gui {

CursorLink::CursorLink() NN_NOEXCEPT
    : m_Direction(Direction::None)
    , m_pLinkObject(nullptr)
{
}

void CursorLink::SetLink(Direction dir, DisplayObject* pObject) NN_NOEXCEPT
{
    NN_ASSERT_NOT_EQUAL(dir, Direction::None);
    NN_ASSERT_NOT_NULL(pObject);

    m_Direction   = dir;
    m_pLinkObject = pObject;
}

}}}  // nns::sgx::gui
