﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   指定範囲に任意の描画を行うためのクラスです。
 */
class Canvas :
    public DisplayObject
{
    NN_DISALLOW_COPY(Canvas);
    NN_DISALLOW_MOVE(Canvas);

public:
    Canvas() NN_NOEXCEPT
        : m_HandlerForRenderContents()
    {}

    virtual Size GetClientAreaSize() const NN_NOEXCEPT;

    virtual Rectangle GetClientArea() const NN_NOEXCEPT;

    /**
     * @brief   コンテンツ領域の描画タイミングで呼び出されるハンドラを登録します。
     *
     * @details ユーザー引数には常に 0 が渡されます。
     */
    void SetRenderContentsHandler(const GuiEventHandler& handler) NN_NOEXCEPT
    {
        SetRenderContentsHandler(handler, 0);
    }

    /**
     * @brief   コンテンツ領域の描画タイミングで呼び出されるハンドラを登録します。
     *
     * @details 登録したハンドラは、RenderContents の後に呼び出されます。
     *          新たなクラスを定義せずに、一部の描画のみ変更したい場合に使用できます。
     */
    void SetRenderContentsHandler(const GuiEventHandler& handler, uintptr_t argument) NN_NOEXCEPT
    {
        NNS_SGX_GUI_SCOPED_LOCK;

        m_HandlerForRenderContents.handler  = handler;
        m_HandlerForRenderContents.argument = argument;
    }

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   コンテンツ領域を描画します。継承先で上書きして使用します。
     */
    virtual void RenderContents() NN_NOEXCEPT {}

private:
    GuiEventHandlerType m_HandlerForRenderContents; //!< コンテンツ領域の描画ハンドラ
};

}}}  // nns::sgx::gui
