﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include "SimpleGfx_Types.h"

namespace nns { namespace sgx {

/**
 * @name    ポストエフェクト API
 * @{
 */

/**
 * @brief   ポストエフェクトを初期化します。
 */
void InitializePostEffect() NN_NOEXCEPT;

/**
 * @brief   ポストエフェクト用のリソースを解放します。
 */
void FinalizePostEffect() NN_NOEXCEPT;

/**
 * @brief   ポストエフェクトが初期化済みか判定します。
 */
bool IsPostEffectInitialized() NN_NOEXCEPT;

/**
 * @brief   呼び出し時点で描画されている画面全体にぼかしをかけます。
 */
void ApplyBlurEffect(float offsetX, float offsetY) NN_NOEXCEPT;

/**
 * @brief   呼び出し時点で描画されている画面の、指定した範囲にぼかしをかけます。
 */
void ApplyBlurEffect(
    float offsetX,
    float offsetY,
    const Rectangle& rect) NN_NOEXCEPT;

/**
 * @}
 */

}}  // nns::sgx
