﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/account.h>

#include "Scene.h"
#include "../sgx/gui/SimpleGfx_Gui.h"
#include "../ui/FirmwareImageButton.h"
#include "../ui/FirmwareInfoView.h"
#include "../ui/FirmwareUpdateProgressDialog.h"
#include "../ui/UniquePadButton.h"
#include "../ui/UniquePadView.h"

namespace nns { namespace hid { namespace scene {

/**
 * @brief   ファームウェア書き込みシーンです。
 */
class FlashWriter final :
    public SceneBase
{
    NN_DISALLOW_COPY(FlashWriter);
    NN_DISALLOW_MOVE(FlashWriter);

public:
    FlashWriter() NN_NOEXCEPT;

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Terminate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

private:
    static void PushImageButtonHandler(NNS_SGX_GUI_EVENT_HANDLER_ARGS(pSender, arg)) NN_NOEXCEPT;

    static void PushPadButtonHandler(const nn::hid::system::UniquePadId& id, uintptr_t arg) NN_NOEXCEPT;

    void UpdateKeyHelp() NN_NOEXCEPT;

    void UpdateForceModeChange() NN_NOEXCEPT;

    void CreateImageButtons() NN_NOEXCEPT;

    int GetActiveImageIndex() NN_NOEXCEPT;

    void StartFirmwareUpdate(const nn::hid::system::UniquePadId& id) NN_NOEXCEPT;

    void ShowMessage(const char* text) NN_NOEXCEPT;

private:
    nns::sgx::gui::Title                m_Title;                    //!< タイトル
    nns::sgx::gui::KeyHelp              m_KeyHelp;                  //!< キーヘルプ
    nns::sgx::gui::FlowLayoutContainer  m_FwImageListContainer;     //!< FW イメージボタン格納用コンテナ

    bool                                m_IsInfoVisible;            //!< 詳細情報の表示状態
    nns::sgx::ImageData                 m_IconImage;                //!< タイトルに表示するアイコン画像
    nns::sgx::gui::ButtonSkin           m_ButtonSkin;               //!< ボタン用スキン
    int                                 m_FwImageButtonCount;       //!< FW イメージボタンの数
    ui::FirmwareImageButton*            m_pFwImageButtons;          //!< FW イメージボタン
    nns::sgx::gui::CheckBox             m_ForceModeCheckBox;        //!< 有効/無効切り替え用チェックボックス
    ui::FirmwareInfoView                m_InfoView;                 //!< 詳細情報
    ui::UniquePadView                   m_PadView;                  //!< コントローラー一覧
    nns::sgx::gui::Label                m_ImageListLabel;           //!< FW イメージ一覧のラベル
    nns::sgx::gui::Label                m_PadListLabel;             //!< コントローラー一覧のラベル
    nns::sgx::gui::Dialog               m_Dialog;                   //!< メッセージ表示用ダイアログ
    ui::FirmwareUpdateProgressDialog    m_ProgressDialog;           //!< 進捗表示ダイアログ

    char*                               m_pImageBuffer;             //!< 更新対象 FW イメージの読み込みバッファ
    size_t                              m_ImageSize;                //!< 更新対象 FW イメージのサイズ
};

}}}  // nns::hid::scene
