﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       画面上に表示されるボタンを、セットで作成するための API の宣言
 */

#pragma once

#include "layout_Base.h"
#include "layout_Button.h"

namespace nns { namespace hidfw { namespace layout {

    /**
     * @brief       画面上に表示されるボタンをセットで描画、状態更新等を行う為のクラスです
     * @details     複数のボタンを1つのグループとして管理したい等に用います
     *              例えば、排他的なモードの切り替え等にこのセットを使用することで
     *              簡単にモード切替のボタンを生成することが出来ます
     */
    class ButtonGroup : public BaseItemSet
    {
    public:
        ButtonGroup() NN_NOEXCEPT {}
        virtual ~ButtonGroup() NN_NOEXCEPT {}

        //----------------------------------------------------------------
        //! @brief      リセット処理
        //! @details    動作コマンドとアニメーションカウンタをクリアします
        //----------------------------------------------------------------
        void Reset() NN_NOEXCEPT;
    };
}}}
