﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../gfx.h"

namespace nns { namespace hidfw { namespace gfx {

    const size_t nns::hidfw::gfx::Graphics::AppMemorySize = 1024 * 1024 * 1024;

    Graphics& Graphics::GetInstance() NN_NOEXCEPT
    {
        static Graphics instance;
        return instance;
    }

    void Graphics::Initialize() NN_NOEXCEPT
    {
        // Memory
        m_pAppMemory = new nn::Bit8[Graphics::AppMemorySize];
        m_AppAllocator.Initialize(m_pAppMemory, Graphics::AppMemorySize);

#if defined( NN_BUILD_TARGET_PLATFORM_OS_NN ) && defined( NN_BUILD_APISET_NX )
        {
            const size_t graphicsMemorySize = 64 * 1024 * 1024;
            nv::SetGraphicsAllocator(nns::gfx::GraphicsFramework::DefaultAllocateFunction, nns::gfx::GraphicsFramework::DefaultFreeFunction, nns::gfx::GraphicsFramework::DefaultReallocateFunction, nullptr);
            nv::InitializeGraphics(malloc(graphicsMemorySize), graphicsMemorySize);
        }
        nv::SetGraphicsDevtoolsAllocator(nns::gfx::GraphicsFramework::DefaultAllocateFunction, nns::gfx::GraphicsFramework::DefaultFreeFunction, nns::gfx::GraphicsFramework::DefaultReallocateFunction, nullptr);
#endif
        // Graphics
        m_GraphicsSystem.SetApplicationHeap(&m_AppAllocator);
        m_GraphicsSystem.Initialize();
        nns::hidfw::gfx::GraphicsDrawer::GetInstance().Initialize(&m_GraphicsSystem);
    }

    void Graphics::Finalize() NN_NOEXCEPT
    {
        nns::hidfw::gfx::GraphicsDrawer::GetInstance().Finalize();
        m_GraphicsSystem.Finalize();
        m_AppAllocator.Finalize();
    }

    nns::hidfw::gfx::GraphicsDrawer& Graphics::GetDrawer() NN_NOEXCEPT
    {
        return nns::hidfw::gfx::GraphicsDrawer::GetInstance();
    }

    nns::hidfw::gfx::GraphicsSystem& Graphics::GetGraphicsSystem() NN_NOEXCEPT
    {
        return m_GraphicsSystem;
    }

    nn::gfx::util::DebugFontTextWriter& Graphics::GetTextWriter() NN_NOEXCEPT
    {
        return m_GraphicsSystem.GetDebugFont();
    }

    //----------------------------------------------------------------
    //! @brief GetInstance の内部で呼び出されます
    //----------------------------------------------------------------
    Graphics::Graphics() NN_NOEXCEPT
    {

    }

}}}
