﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/rid.h>
#include "DevQuestMenu_UpdateCheckModeScene.h"
#include "../DevQuestMenu_Log.h"

namespace nn { namespace devquestmenu {

    UpdateCheckModeScene::UpdateCheckModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT
        : ModeSceneCommon("Update Check Mode", pRootSurface)
    {
        // 更新チェックモードの開始時に必要な処理を行う
        NN_ABORT_UNLESS_RESULT_SUCCESS(rid::MinimumStartUp());
    };

    void UpdateCheckModeScene::OnLoop() NN_NOEXCEPT
    {
    };

    ModeType UpdateCheckModeScene::DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT
    {
        //! 要試遊台メニュー更新フラグ判定
        if (m_pRootSurface->IsMenuUpdateRequired())
        {
            return ModeType_SystemUpdateMode;
        }
        else
        {
            //! 試遊モード時間判定
            if (displayModeTime.IsDuringDisplayModeTime())
            {
                //! アプリケーション更新中フラグ判定
                if (m_pRootSurface->IsApplicationUpdating())
                {
                    return ModeType_PrepareMode;
                }
                else
                {
                    return ModeType_DisplayMode;
                }
            }
            else
            {
                return ModeType_SystemUpdateMode;
            }
        }
    };

    ModeType UpdateCheckModeScene::GetSuccessNextMode() NN_NOEXCEPT
    {
        return ModeType_DisplayMode;
    };
}}
