﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "../DevQuestMenu_Log.h"
#include "DevQuestMenu_ModeSceneCommon.h"

namespace nn { namespace devquestmenu {

    ModeSceneCommon::ModeSceneCommon(const char* caption, RootSurfaceContext* pRootSurface) NN_NOEXCEPT
        : glv::View(glv::Rect(pRootSurface->GetDisplayWidth(), pRootSurface->GetDisplayHeight()))
        , m_ModeCaption(caption)
        , m_pRootSurface(pRootSurface)
        , m_GridWidth(pRootSurface->GetDisplayGridWidth())
        , m_GridHeight(pRootSurface->GetDisplayGridHeight())
    {
        enable(
            glv::Property::DrawBack
            | glv::Property::DrawBorder
            | glv::Property::CropChildren
            | glv::Property::Controllable
            | glv::Property::GestureDetectability);

        disable(glv::Property::FocusToTop);

        QUESTMENU_LOG("Start %s\n", m_ModeCaption);
    };

    /**
     * @brief       ラベルを作成します
     *
     * @param[in]   label       表示
     * @param[in]   spec        位置
     */
    std::unique_ptr<glv::Label> ModeSceneCommon::MakeLabel(const std::string& label, const glv::Label::Spec& spec) NN_NOEXCEPT
    {
        std::unique_ptr<glv::Label> object(new glv::Label(label, spec));
        *this << object.get();
        return object;
    }

    /**
     * @brief       ラベルを作成します
     *
     * @param[in]   label       表示
     * @param[in]   spec        位置
     */
    std::unique_ptr<glv::Label> ModeSceneCommon::MakeLabel(glv::ViewContainer* pContainer, const std::string& label, const glv::Label::Spec& spec) NN_NOEXCEPT
    {
        std::unique_ptr<glv::Label> object(new glv::Label(label, spec));
        *pContainer << object.get();
        return object;
    }

    /**
     * @brief       ボタンを作成します
     *
     * @param[in]   label       表示
     * @param[in]   callback    実行される関数
     * @param[in]   r           位置・大きさ
     */
    std::unique_ptr<LabelButton> ModeSceneCommon::MakeLabelButton(const std::string& label, std::function< void() > callback, const glv::Rect& r) NN_NOEXCEPT
    {
        std::unique_ptr<LabelButton> object(new LabelButton(label.c_str(), callback, r));
        *this << object.get();
        return object;
    }

    /**
     * @brief       ボタンを作成します
     *
     * @param[in]   label       表示
     * @param[in]   callback    実行される関数
     * @param[in]   r           位置・大きさ
     */
    std::unique_ptr<LabelButton> ModeSceneCommon::MakeLabelButton(glv::ViewContainer* pContainer, const std::string& label, std::function< void() > callback, const glv::Rect& r) NN_NOEXCEPT
    {
        std::unique_ptr<LabelButton> object(new LabelButton(label.c_str(), callback, r));
        *pContainer << object.get();
        return object;
    }
}}
