﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/rid.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/time/time_CalendarTime.h>

namespace nn { namespace devquestmenu {

    /**
     * @brief       SD カードに保存された試遊モード時間の設定を取得します。
     *
     * @detail      SD カードの
     *              NintendoSDK/RetailInteractiveDisplay/DisplayModeSettings.json
     *              のファイルを読み込み、試遊モード時間の設定を取得します。
     *
     * @param[out]  outStartTime    試遊モードの開始時間
     * @param[out]  outEndTime      試遊モードの終了時間
     * @return      設定の読み込みに成功した場合は true, 失敗した場合は false が返ります。
     */
    bool ReadDisplayModeSettingsForDebug(time::CalendarTime* outStartTime, time::CalendarTime* outEndTime) NN_NOEXCEPT;

    /**
     * @brief       SD カードに保存された体験終了タイマーの設定を取得します。
     *
     * @detail      SD カードの
     *              NintendoSDK/RetailInteractiveDisplay/TimerSettings.json
     *              のファイルを読み込み、体験終了タイマーの設定を取得します。
     *
     * @param[out]  outValue        体験終了タイマーの設定が有効か
     * @return      設定の読み込みに成功した場合は true, 失敗した場合は false が返ります。
     */
    bool ReadPlayableTimerSettingsForDebug(bool* outValue) NN_NOEXCEPT;

    /**
     * @brief       SD カードに保存された無操作タイマーの設定を取得します。
     *
     * @detail      SD カードの
     *              NintendoSDK/RetailInteractiveDisplay/TimerSettings.json
     *              のファイルを読み込み、無操作タイマーの設定を取得します。
     *
     * @param[out]  outValue        無操作タイマーの設定が有効か
     * @param[out]  outTime         無操作タイマーの設定が有効な場合に無操作で終了する場合まで時間(秒)
     * @return      設定の読み込みに成功した場合は true, 失敗した場合は false が返ります。
     */
    bool ReadIdleDetectionTimerSettingsForDebug(bool* outValue, uint32_t* outTime) NN_NOEXCEPT;

    /**
     * @brief       SD カードに保存されたアプリケーション更新リストを取得し、ApplicationAsset 配列をを作成します。
     *
     * @detail      SD カードの
     *              NintendoSDK/RetailInteractiveDisplay/ContentList.json
     *              のファイルを読み込み、アプリケーション更新リストを作成します。
     *
     * @param[out]  outAssetListCount   作成した ApplicationAsset 配列の要素数
     * @param[out]  outAssetList        作成する ApplicationAsset の出力先
     * @param[in]   assetListLength     outAssetList 配列の要素数
     * @return      アプリケーション更新リストの読み込みに成功した場合は true, 失敗した場合は false が返ります。
     */
    bool ReadUpdateApplicationListAndCreateAssetListForDebug(int* outAssetListCount, rid::ApplicationAsset outAssetList[], int assetListLength) NN_NOEXCEPT;
}}
