﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemAttributeLeafItem.h"
#include "base/ui_MenuItemAttributeTraceFocusState.h"
#include "base/ui_MenuItemAttributeAnalogStickInputCallback.h"
#include "base/ui_MenuItemAttributeTouchCallback.h"
#include "base/ui_MenuItemStyleProperty.h"
#include "../panel/panel_PanelContainer.h"

namespace ui{

    class MenuItemUserCustomStyle
        : public
            base::MenuItemStylePropertySizeStyle<base::StateNone,
            base::MenuItemStylePropertyAlignment<base::StateNone,
            base::MenuItemStylePropertyBackgroundStyle<base::StateNone,
            base::MenuItemStylePropertyMargin<base::StateNone,
            base::MenuItemStyleBase<MenuItemUserCustomStyle>
            >>>>
    {};

    class MenuItemUserCustom
        : public  base::MenuItemAttributeTouchCallback
                < base::MenuItemAttributeAnalogStickInputCallback
                < base::MenuItemAttributeTraceFocusState
                < base::MenuItemAttributeLeafItem
                < base::MenuItemBase<IMenuItem, MenuItemUserCustom>
                >>>>
    {
    public:
        explicit MenuItemUserCustom(const MenuItemUserCustomStyle& style) NN_NOEXCEPT;

        virtual bool IsFocusAcceptable() const NN_NOEXCEPT UI_FINAL { return m_IsFocusAcceptable; }
        virtual bool IsTouchAcceptable() const NN_NOEXCEPT UI_FINAL { return m_IsTouchAcceptable; }

        virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT UI_FINAL;
        virtual void UpdatePanel() NN_NOEXCEPT UI_FINAL;
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT UI_FINAL;

        std::shared_ptr<MenuItemUserCustom> SetFocusAcceptable(bool value) NN_NOEXCEPT;
        std::shared_ptr<MenuItemUserCustom> SetTouchAcceptable(bool value) NN_NOEXCEPT;
        std::shared_ptr<MenuItemUserCustom> SetExternalPanel(const std::shared_ptr<panel::IPanel>& value) NN_NOEXCEPT;
        std::shared_ptr<MenuItemUserCustom> SetUpdateLayoutCallbackFunction(const std::function<ui::Size ()>& value) NN_NOEXCEPT;
        std::shared_ptr<MenuItemUserCustom> SetUpdatePanelCallbackFunction(const std::function<void (const ui::Position&)>& value) NN_NOEXCEPT;

    private:
        MenuItemUserCustomStyle m_Style = {};

        std::shared_ptr<panel::PanelContainer> m_pContainer;

        bool m_IsFocusAcceptable = false;
        bool m_IsTouchAcceptable = false;
        std::shared_ptr<panel::IPanel> m_pExternalPanel;
        ui::Position m_ExternalPanelPosition = {};
        std::function<ui::Size ()> m_UpdateLayoutCallbackFunction;
        std::function<void (const ui::Position&)> m_UpdatePanelCallbackFunction;
    };

}
