﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../panel/panel_PanelText.h"
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemAttributeLeafItem.h"
#include "base/ui_MenuItemAttributeTraceFocusState.h"
#include "base/ui_MenuItemAttributeButtonCallback.h"
#include "base/ui_MenuItemStyleProperty.h"

namespace ui{

    enum Icon
    {
        Icon_None = 0, // 空白

        Icon_LeftStick,
        Icon_RightStick,

        Icon_RightStickUpDown, // ↑(R)↓

        Icon_ArrowRight,
        Icon_ArrowLeft,
        Icon_ArrowUp,
        Icon_ArrowDown,
        Icon_ArrowUpRight,
        Icon_ArrowDownRight,
        Icon_ArrowDownLeft,
        Icon_ArrowUpLeft,

        Icon_DirectionUp,
        Icon_DirectionDown,
        Icon_DirectionLeft,
        Icon_DirectionRight,
    };

    class MenuItemIconStyle
        : public
            base::MenuItemStylePropertySizeStyle<base::StateNone,
            base::MenuItemStylePropertyMargin<base::StateNone,
            base::MenuItemStylePropertyAlignment<base::StateNone,
            base::MenuItemStylePropertyBackgroundColor<base::StateEnablityFocus,
            base::MenuItemStylePropertyIconStyle<base::StateEnablityFocus,
            base::MenuItemStyleBase<MenuItemIconStyle>
            >>>>>
    {
    };

    class MenuItemIcon
        : public  base::MenuItemAttributeButtonCallback
                < base::MenuItemAttributeTraceFocusState
                < base::MenuItemAttributeLeafItem
                < base::MenuItemBase<IMenuItem, MenuItemIcon>
                >>>
    {
    public:
        MenuItemIcon(const MenuItemIconStyle& style, Icon icon) NN_NOEXCEPT;

        virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT UI_FINAL;

        virtual bool IsFocusAcceptable() const NN_NOEXCEPT UI_FINAL;
        virtual bool IsTouchAcceptable() const NN_NOEXCEPT UI_FINAL;

        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT UI_FINAL;
        virtual void UpdatePanel() NN_NOEXCEPT UI_FINAL;

    protected:
        std::shared_ptr<panel::PanelText> m_pPanel;
        MenuItemIconStyle m_Style;

        Position m_IconPosition = {};
    };

}
