﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../panel/panel_PanelContainer.h"
#include "../panel/panel_PanelText.h"
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemAttributeLeafItem.h"
#include "base/ui_MenuItemAttributeTraceFocusState.h"
#include "base/ui_MenuItemStyleProperty.h"

namespace ui{

    class MenuItemCheckBoxStyle
        : public
            base::MenuItemStylePropertySizeStyle<base::StateNone,
            base::MenuItemStylePropertyMargin<base::StateNone,
            base::MenuItemStylePropertyAlignment<base::StateNone,
            base::MenuItemStylePropertyBackgroundColor<base::StateEnablityFocusSelection,
            base::MenuItemStylePropertyTextStyle<base::StateEnablityFocusSelection,
            base::MenuItemStylePropertyCheckMarkStyle<base::StateEnablityFocusSelection,
            base::MenuItemStyleBase<MenuItemCheckBoxStyle>
            >>>>>>
    {
    };

    class MenuItemCheckBox
        : public  base::MenuItemAttributeTraceFocusState
                < base::MenuItemAttributeLeafItem
                < base::MenuItemBase<IMenuItem, MenuItemCheckBox>
                >>
    {
    public:
        enum State
        {
            State_Unspecified = 0, // 初期状態
            State_NotChecked,
            State_Checked,
        };

    protected:
        struct MarkLayout
        {
            Size m_ContainerSize = {};
            Size m_PanelSize = {};
            Position m_PanelPosition = {};
            Position m_IconPlotPosition = {};
        };

        struct TextLayout
        {
            Size m_TextSize = {};
        };

    public:
        MenuItemCheckBox(const MenuItemCheckBoxStyle& style, const std::string& text) NN_NOEXCEPT;

        std::shared_ptr<MenuItemCheckBox> SetValueAccessor(const std::function<bool ()>& getter, const std::function<void (bool)>& setter) NN_NOEXCEPT;
        std::shared_ptr<MenuItemCheckBox> SetValueChangedCallbackFunction(const std::function<void (bool, const std::shared_ptr<IMenuPage>&)>& f) NN_NOEXCEPT;
        bool IsSelected() const NN_NOEXCEPT;

        // Geometry
        virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT UI_FINAL;

        // Focus/Touch
        virtual bool IsFocusAcceptable() const NN_NOEXCEPT UI_FINAL;
        virtual bool IsTouchAcceptable() const NN_NOEXCEPT UI_FINAL;

        // User Input
        virtual MenuButtonResult HandlePositiveButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT UI_FINAL;
        virtual MenuButtonResult HandleTouched(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT UI_FINAL;

        // Load/Store Value
        virtual void LoadValue(const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT UI_FINAL;
        virtual void StoreValue() const NN_NOEXCEPT UI_FINAL;

        // Rendering
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT UI_FINAL;
        virtual void UpdatePanel() NN_NOEXCEPT UI_FINAL;

    private:
        void SetValueImpl(bool isSelected, const std::shared_ptr<IMenuPage>& pPage) NN_NOEXCEPT;

        MarkLayout CalculateMarkLayoutImpl() const NN_NOEXCEPT;
        TextLayout CalculateTextLayoutImpl() const NN_NOEXCEPT;

    protected:
        MenuItemCheckBoxStyle m_Style;
        std::shared_ptr<panel::PanelContainer> m_pContainer;
        std::shared_ptr<panel::PanelContainer> m_pCheckMarkContainer;
        std::shared_ptr<panel::PanelText> m_pPanelCheckMark;
        std::shared_ptr<panel::PanelText> m_pPanelText;

        State m_CheckState = State_Unspecified;
        std::function<bool ()> m_ValueLoadFunction;
        std::function<void (bool)> m_ValueStoreFunction;
        std::function<void (bool, const std::shared_ptr<IMenuPage>&)> m_ValueChangedCallbackFunction;

        struct {
            MarkLayout m_MarkLayout;
            Position m_MarkPanelPosition;
            Position m_TextPanelPosition;
            Size     m_TextPanelSize;
            Position m_TextPlotPosition;
        } m_Layout;
    };

}
